/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCachediScsiVolumeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<CreateCachediScsiVolumeRequest.Builder, CreateCachediScsiVolumeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCachediScsiVolumeRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<Long> VOLUME_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateCachediScsiVolumeRequest::volumeSizeInBytes)).setter(setter(Builder::volumeSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInBytes").build()).build();

    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCachediScsiVolumeRequest::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCachediScsiVolumeRequest::targetName)).setter(setter(Builder::targetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetName").build()).build();

    private static final SdkField<String> SOURCE_VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCachediScsiVolumeRequest::sourceVolumeARN)).setter(setter(Builder::sourceVolumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceVolumeARN").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCachediScsiVolumeRequest::networkInterfaceId)).setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCachediScsiVolumeRequest::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<Boolean> KMS_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateCachediScsiVolumeRequest::kmsEncrypted)).setter(setter(Builder::kmsEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSEncrypted").build()).build();

    private static final SdkField<String> KMS_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateCachediScsiVolumeRequest::kmsKey)).setter(setter(Builder::kmsKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKey").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateCachediScsiVolumeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            VOLUME_SIZE_IN_BYTES_FIELD, SNAPSHOT_ID_FIELD, TARGET_NAME_FIELD, SOURCE_VOLUME_ARN_FIELD,
            NETWORK_INTERFACE_ID_FIELD, CLIENT_TOKEN_FIELD, KMS_ENCRYPTED_FIELD, KMS_KEY_FIELD, TAGS_FIELD));

    private final String gatewayARN;

    private final Long volumeSizeInBytes;

    private final String snapshotId;

    private final String targetName;

    private final String sourceVolumeARN;

    private final String networkInterfaceId;

    private final String clientToken;

    private final Boolean kmsEncrypted;

    private final String kmsKey;

    private final List<Tag> tags;

    private CreateCachediScsiVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.volumeSizeInBytes = builder.volumeSizeInBytes;
        this.snapshotId = builder.snapshotId;
        this.targetName = builder.targetName;
        this.sourceVolumeARN = builder.sourceVolumeARN;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.clientToken = builder.clientToken;
        this.kmsEncrypted = builder.kmsEncrypted;
        this.kmsKey = builder.kmsKey;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The size of the volume in bytes.
     * </p>
     * 
     * @return The size of the volume in bytes.
     */
    public Long volumeSizeInBytes() {
        return volumeSizeInBytes;
    }

    /**
     * <p>
     * The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this field if
     * you want to create the iSCSI storage volume from a snapshot otherwise do not include this field. To list
     * snapshots for your account use <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html"
     * >DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     * </p>
     * 
     * @return The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this
     *         field if you want to create the iSCSI storage volume from a snapshot otherwise do not include this field.
     *         To list snapshots for your account use <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html"
     *         >DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN.
     * For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of
     * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
     * . The target name must be unique across all volumes on a gateway.
     * </p>
     * <p>
     * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new
     * target name.
     * </p>
     * 
     * @return The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the
     *         target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN
     *         of
     *         <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
     *         . The target name must be unique across all volumes on a gateway.</p>
     *         <p>
     *         If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as
     *         the new target name.
     */
    public String targetName() {
        return targetName;
    }

    /**
     * <p>
     * The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified
     * existing volume's latest recovery point. The <code>VolumeSizeInBytes</code> value for this new volume must be
     * equal to or larger than the size of the existing volume, in bytes.
     * </p>
     * 
     * @return The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the
     *         specified existing volume's latest recovery point. The <code>VolumeSizeInBytes</code> value for this new
     *         volume must be equal to or larger than the size of the existing volume, in bytes.
     */
    public String sourceVolumeARN() {
        return sourceVolumeARN;
    }

    /**
     * <p>
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use
     * <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.
     * </p>
     * <p>
     * Valid Values: A valid IP address.
     * </p>
     * 
     * @return The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are
     *         accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a
     *         gateway.</p>
     *         <p>
     *         Valid Values: A valid IP address.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * A unique identifier that you use to retry a request. If you retry a request, use the same
     * <code>ClientToken</code> you specified in the initial request.
     * </p>
     * 
     * @return A unique identifier that you use to retry a request. If you retry a request, use the same
     *         <code>ClientToken</code> you specified in the initial request.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * True to use Amazon S3 server-side encryption with your own AWS KMS key, or false to use a key managed by Amazon
     * S3. Optional.
     * </p>
     * 
     * @return True to use Amazon S3 server-side encryption with your own AWS KMS key, or false to use a key managed by
     *         Amazon S3. Optional.
     */
    public Boolean kmsEncrypted() {
        return kmsEncrypted;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server-side encryption. This value can only
     * be set when KMSEncrypted is true. Optional.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server-side encryption. This value
     *         can only be set when KMSEncrypted is true. Optional.
     */
    public String kmsKey() {
        return kmsKey;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.
     * </p>
     * <note>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format, and
     * the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
     * maximum length for a tag's value is 256 characters.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.</p> <note>
     *         <p>
     *         Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8
     *         format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
     *         characters, and the maximum length for a tag's value is 256 characters.
     *         </p>
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVolumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCachediScsiVolumeRequest)) {
            return false;
        }
        CreateCachediScsiVolumeRequest other = (CreateCachediScsiVolumeRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(volumeSizeInBytes(), other.volumeSizeInBytes())
                && Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(targetName(), other.targetName())
                && Objects.equals(sourceVolumeARN(), other.sourceVolumeARN())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(kmsEncrypted(), other.kmsEncrypted())
                && Objects.equals(kmsKey(), other.kmsKey()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateCachediScsiVolumeRequest").add("GatewayARN", gatewayARN())
                .add("VolumeSizeInBytes", volumeSizeInBytes()).add("SnapshotId", snapshotId()).add("TargetName", targetName())
                .add("SourceVolumeARN", sourceVolumeARN()).add("NetworkInterfaceId", networkInterfaceId())
                .add("ClientToken", clientToken()).add("KMSEncrypted", kmsEncrypted()).add("KMSKey", kmsKey())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "VolumeSizeInBytes":
            return Optional.ofNullable(clazz.cast(volumeSizeInBytes()));
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "TargetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        case "SourceVolumeARN":
            return Optional.ofNullable(clazz.cast(sourceVolumeARN()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "KMSEncrypted":
            return Optional.ofNullable(clazz.cast(kmsEncrypted()));
        case "KMSKey":
            return Optional.ofNullable(clazz.cast(kmsKey()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCachediScsiVolumeRequest, T> g) {
        return obj -> g.apply((CreateCachediScsiVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCachediScsiVolumeRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The size of the volume in bytes.
         * </p>
         * 
         * @param volumeSizeInBytes
         *        The size of the volume in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInBytes(Long volumeSizeInBytes);

        /**
         * <p>
         * The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify this
         * field if you want to create the iSCSI storage volume from a snapshot otherwise do not include this field. To
         * list snapshots for your account use <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html"
         * >DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID (e.g. "snap-1122aabb") of the snapshot to restore as the new cached volume. Specify
         *        this field if you want to create the iSCSI storage volume from a snapshot otherwise do not include
         *        this field. To list snapshots for your account use <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeSnapshots.html"
         *        >DescribeSnapshots</a> in the <i>Amazon Elastic Compute Cloud API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target
         * ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of
         * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
         * . The target name must be unique across all volumes on a gateway.
         * </p>
         * <p>
         * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the
         * new target name.
         * </p>
         * 
         * @param targetName
         *        The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the
         *        target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target
         *        ARN of
         *        <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
         *        . The target name must be unique across all volumes on a gateway.</p>
         *        <p>
         *        If you don't specify a value, Storage Gateway uses the value that was previously used for this volume
         *        as the new target name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);

        /**
         * <p>
         * The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified
         * existing volume's latest recovery point. The <code>VolumeSizeInBytes</code> value for this new volume must be
         * equal to or larger than the size of the existing volume, in bytes.
         * </p>
         * 
         * @param sourceVolumeARN
         *        The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the
         *        specified existing volume's latest recovery point. The <code>VolumeSizeInBytes</code> value for this
         *        new volume must be equal to or larger than the size of the existing volume, in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVolumeARN(String sourceVolumeARN);

        /**
         * <p>
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
         * Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.
         * </p>
         * <p>
         * Valid Values: A valid IP address.
         * </p>
         * 
         * @param networkInterfaceId
         *        The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are
         *        accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a
         *        gateway.</p>
         *        <p>
         *        Valid Values: A valid IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * A unique identifier that you use to retry a request. If you retry a request, use the same
         * <code>ClientToken</code> you specified in the initial request.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier that you use to retry a request. If you retry a request, use the same
         *        <code>ClientToken</code> you specified in the initial request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * True to use Amazon S3 server-side encryption with your own AWS KMS key, or false to use a key managed by
         * Amazon S3. Optional.
         * </p>
         * 
         * @param kmsEncrypted
         *        True to use Amazon S3 server-side encryption with your own AWS KMS key, or false to use a key managed
         *        by Amazon S3. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncrypted(Boolean kmsEncrypted);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server-side encryption. This value can
         * only be set when KMSEncrypted is true. Optional.
         * </p>
         * 
         * @param kmsKey
         *        The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server-side encryption. This
         *        value can only be set when KMSEncrypted is true. Optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKey(String kmsKey);

        /**
         * <p>
         * A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format,
         * and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
         * and the maximum length for a tag's value is 256 characters.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.</p>
         *        <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8
         *        format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is
         *        128 characters, and the maximum length for a tag's value is 256 characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format,
         * and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
         * and the maximum length for a tag's value is 256 characters.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.</p>
         *        <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8
         *        format, and the following special characters: + - = . _ : / @. The maximum length of a tag's key is
         *        128 characters, and the maximum length for a tag's value is 256 characters.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags that you can assign to a cached volume. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers that you can represent in UTF-8 format,
         * and the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
         * and the maximum length for a tag's value is 256 characters.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private Long volumeSizeInBytes;

        private String snapshotId;

        private String targetName;

        private String sourceVolumeARN;

        private String networkInterfaceId;

        private String clientToken;

        private Boolean kmsEncrypted;

        private String kmsKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCachediScsiVolumeRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            volumeSizeInBytes(model.volumeSizeInBytes);
            snapshotId(model.snapshotId);
            targetName(model.targetName);
            sourceVolumeARN(model.sourceVolumeARN);
            networkInterfaceId(model.networkInterfaceId);
            clientToken(model.clientToken);
            kmsEncrypted(model.kmsEncrypted);
            kmsKey(model.kmsKey);
            tags(model.tags);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Long getVolumeSizeInBytes() {
            return volumeSizeInBytes;
        }

        @Override
        public final Builder volumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
            return this;
        }

        public final void setVolumeSizeInBytes(Long volumeSizeInBytes) {
            this.volumeSizeInBytes = volumeSizeInBytes;
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getTargetName() {
            return targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        public final String getSourceVolumeARN() {
            return sourceVolumeARN;
        }

        @Override
        public final Builder sourceVolumeARN(String sourceVolumeARN) {
            this.sourceVolumeARN = sourceVolumeARN;
            return this;
        }

        public final void setSourceVolumeARN(String sourceVolumeARN) {
            this.sourceVolumeARN = sourceVolumeARN;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Boolean getKmsEncrypted() {
            return kmsEncrypted;
        }

        @Override
        public final Builder kmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
            return this;
        }

        public final void setKmsEncrypted(Boolean kmsEncrypted) {
            this.kmsEncrypted = kmsEncrypted;
        }

        public final String getKmsKey() {
            return kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCachediScsiVolumeRequest build() {
            return new CreateCachediScsiVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
