/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddUploadBufferRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<AddUploadBufferRequest.Builder, AddUploadBufferRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddUploadBufferRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<List<String>> DISK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(AddUploadBufferRequest::diskIds))
            .setter(setter(Builder::diskIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            DISK_IDS_FIELD));

    private final String gatewayARN;

    private final List<String> diskIds;

    private AddUploadBufferRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.diskIds = builder.diskIds;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * Returns true if the DiskIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDiskIds() {
        return diskIds != null && !(diskIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that identify disks that are to be configured as working storage. Each string has a minimum
     * length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDiskIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of strings that identify disks that are to be configured as working storage. Each string has a
     *         minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a>
     *         API.
     */
    public List<String> diskIds() {
        return diskIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(diskIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddUploadBufferRequest)) {
            return false;
        }
        AddUploadBufferRequest other = (AddUploadBufferRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(diskIds(), other.diskIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AddUploadBufferRequest").add("GatewayARN", gatewayARN()).add("DiskIds", diskIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "DiskIds":
            return Optional.ofNullable(clazz.cast(diskIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddUploadBufferRequest, T> g) {
        return obj -> g.apply((AddUploadBufferRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddUploadBufferRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * An array of strings that identify disks that are to be configured as working storage. Each string has a
         * minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.
         * </p>
         * 
         * @param diskIds
         *        An array of strings that identify disks that are to be configured as working storage. Each string has
         *        a minimum length of 1 and maximum length of 300. You can get the disk IDs from the
         *        <a>ListLocalDisks</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIds(Collection<String> diskIds);

        /**
         * <p>
         * An array of strings that identify disks that are to be configured as working storage. Each string has a
         * minimum length of 1 and maximum length of 300. You can get the disk IDs from the <a>ListLocalDisks</a> API.
         * </p>
         * 
         * @param diskIds
         *        An array of strings that identify disks that are to be configured as working storage. Each string has
         *        a minimum length of 1 and maximum length of 300. You can get the disk IDs from the
         *        <a>ListLocalDisks</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIds(String... diskIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private List<String> diskIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddUploadBufferRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            diskIds(model.diskIds);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final Collection<String> getDiskIds() {
            return diskIds;
        }

        @Override
        public final Builder diskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskIds(String... diskIds) {
            diskIds(Arrays.asList(diskIds));
            return this;
        }

        public final void setDiskIds(Collection<String> diskIds) {
            this.diskIds = DiskIdsCopier.copy(diskIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddUploadBufferRequest build() {
            return new AddUploadBufferRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
