/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing one or more of the following fields:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>UpdateSnapshotScheduleInput$Description</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateSnapshotScheduleInput$RecurrenceInHours</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateSnapshotScheduleInput$StartAt</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>UpdateSnapshotScheduleInput$VolumeARN</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSnapshotScheduleRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<UpdateSnapshotScheduleRequest.Builder, UpdateSnapshotScheduleRequest> {
    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSnapshotScheduleRequest::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<Integer> START_AT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateSnapshotScheduleRequest::startAt)).setter(setter(Builder::startAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartAt").build()).build();

    private static final SdkField<Integer> RECURRENCE_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateSnapshotScheduleRequest::recurrenceInHours)).setter(setter(Builder::recurrenceInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurrenceInHours").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateSnapshotScheduleRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(UpdateSnapshotScheduleRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ARN_FIELD,
            START_AT_FIELD, RECURRENCE_IN_HOURS_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));

    private final String volumeARN;

    private final Integer startAt;

    private final Integer recurrenceInHours;

    private final String description;

    private final List<Tag> tags;

    private UpdateSnapshotScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.volumeARN = builder.volumeARN;
        this.startAt = builder.startAt;
        this.recurrenceInHours = builder.recurrenceInHours;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of gateway
     * volumes.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of
     *         gateway volumes.
     */
    public String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the hour
     * (0 to 23). The hour of the day is in the time zone of the gateway.
     * </p>
     * 
     * @return The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is
     *         the hour (0 to 23). The hour of the day is in the time zone of the gateway.
     */
    public Integer startAt() {
        return startAt;
    }

    /**
     * <p>
     * Frequency of snapshots. Specify the number of hours between snapshots.
     * </p>
     * 
     * @return Frequency of snapshots. Specify the number of hours between snapshots.
     */
    public Integer recurrenceInHours() {
        return recurrenceInHours;
    }

    /**
     * <p>
     * Optional description of the snapshot that overwrites the existing description.
     * </p>
     * 
     * @return Optional description of the snapshot that overwrites the existing description.
     */
    public String description() {
        return description;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
     * </p>
     * <note>
     * <p>
     * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
     * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
     * maximum length for a tag's value is 256.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
     *         <p>
     *         Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
     *         the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters,
     *         and the maximum length for a tag's value is 256.
     *         </p>
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(startAt());
        hashCode = 31 * hashCode + Objects.hashCode(recurrenceInHours());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSnapshotScheduleRequest)) {
            return false;
        }
        UpdateSnapshotScheduleRequest other = (UpdateSnapshotScheduleRequest) obj;
        return Objects.equals(volumeARN(), other.volumeARN()) && Objects.equals(startAt(), other.startAt())
                && Objects.equals(recurrenceInHours(), other.recurrenceInHours())
                && Objects.equals(description(), other.description()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateSnapshotScheduleRequest").add("VolumeARN", volumeARN()).add("StartAt", startAt())
                .add("RecurrenceInHours", recurrenceInHours()).add("Description", description()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "StartAt":
            return Optional.ofNullable(clazz.cast(startAt()));
        case "RecurrenceInHours":
            return Optional.ofNullable(clazz.cast(recurrenceInHours()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSnapshotScheduleRequest, T> g) {
        return obj -> g.apply((UpdateSnapshotScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSnapshotScheduleRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of
         * gateway volumes.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the volume. Use the <a>ListVolumes</a> operation to return a list of
         *        gateway volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is the
         * hour (0 to 23). The hour of the day is in the time zone of the gateway.
         * </p>
         * 
         * @param startAt
         *        The hour of the day at which the snapshot schedule begins represented as <i>hh</i>, where <i>hh</i> is
         *        the hour (0 to 23). The hour of the day is in the time zone of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startAt(Integer startAt);

        /**
         * <p>
         * Frequency of snapshots. Specify the number of hours between snapshots.
         * </p>
         * 
         * @param recurrenceInHours
         *        Frequency of snapshots. Specify the number of hours between snapshots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrenceInHours(Integer recurrenceInHours);

        /**
         * <p>
         * Optional description of the snapshot that overwrites the existing description.
         * </p>
         * 
         * @param description
         *        Optional description of the snapshot that overwrites the existing description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note>
         * 
         * @param tags
         *        A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.</p> <note>
         *        <p>
         *        Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and
         *        the following special characters: + - = . _ : / @. The maximum length of a tag's key is 128
         *        characters, and the maximum length for a tag's value is 256.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of up to 50 tags that can be assigned to a snapshot. Each tag is a key-value pair.
         * </p>
         * <note>
         * <p>
         * Valid characters for key and value are letters, spaces, and numbers representable in UTF-8 format, and the
         * following special characters: + - = . _ : / @. The maximum length of a tag's key is 128 characters, and the
         * maximum length for a tag's value is 256.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String volumeARN;

        private Integer startAt;

        private Integer recurrenceInHours;

        private String description;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSnapshotScheduleRequest model) {
            super(model);
            volumeARN(model.volumeARN);
            startAt(model.startAt);
            recurrenceInHours(model.recurrenceInHours);
            description(model.description);
            tags(model.tags);
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final Integer getStartAt() {
            return startAt;
        }

        @Override
        public final Builder startAt(Integer startAt) {
            this.startAt = startAt;
            return this;
        }

        public final void setStartAt(Integer startAt) {
            this.startAt = startAt;
        }

        public final Integer getRecurrenceInHours() {
            return recurrenceInHours;
        }

        @Override
        public final Builder recurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
            return this;
        }

        public final void setRecurrenceInHours(Integer recurrenceInHours) {
            this.recurrenceInHours = recurrenceInHours;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSnapshotScheduleRequest build() {
            return new UpdateSnapshotScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
