/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * SetLocalConsolePasswordInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetLocalConsolePasswordRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<SetLocalConsolePasswordRequest.Builder, SetLocalConsolePasswordRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetLocalConsolePasswordRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> LOCAL_CONSOLE_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SetLocalConsolePasswordRequest::localConsolePassword)).setter(setter(Builder::localConsolePassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalConsolePassword").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            LOCAL_CONSOLE_PASSWORD_FIELD));

    private final String gatewayARN;

    private final String localConsolePassword;

    private SetLocalConsolePasswordRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.localConsolePassword = builder.localConsolePassword;
    }

    /**
     * Returns the value of the GatewayARN property for this object.
     * 
     * @return The value of the GatewayARN property for this object.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The password you want to set for your VM local console.
     * </p>
     * 
     * @return The password you want to set for your VM local console.
     */
    public String localConsolePassword() {
        return localConsolePassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(localConsolePassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLocalConsolePasswordRequest)) {
            return false;
        }
        SetLocalConsolePasswordRequest other = (SetLocalConsolePasswordRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN())
                && Objects.equals(localConsolePassword(), other.localConsolePassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetLocalConsolePasswordRequest").add("GatewayARN", gatewayARN())
                .add("LocalConsolePassword", localConsolePassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "LocalConsolePassword":
            return Optional.ofNullable(clazz.cast(localConsolePassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetLocalConsolePasswordRequest, T> g) {
        return obj -> g.apply((SetLocalConsolePasswordRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SetLocalConsolePasswordRequest> {
        /**
         * Sets the value of the GatewayARN property for this object.
         *
         * @param gatewayARN
         *        The new value for the GatewayARN property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The password you want to set for your VM local console.
         * </p>
         * 
         * @param localConsolePassword
         *        The password you want to set for your VM local console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localConsolePassword(String localConsolePassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String localConsolePassword;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLocalConsolePasswordRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            localConsolePassword(model.localConsolePassword);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getLocalConsolePassword() {
            return localConsolePassword;
        }

        @Override
        public final Builder localConsolePassword(String localConsolePassword) {
            this.localConsolePassword = localConsolePassword;
            return this;
        }

        public final void setLocalConsolePassword(String localConsolePassword) {
            this.localConsolePassword = localConsolePassword;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetLocalConsolePasswordRequest build() {
            return new SetLocalConsolePasswordRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
