/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An internal server error has occurred because the service is unavailable. For more information, see the error and
 * message fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceUnavailableErrorException extends StorageGatewayException implements
        ToCopyableBuilder<ServiceUnavailableErrorException.Builder, ServiceUnavailableErrorException> {
    private static final SdkField<StorageGatewayError> ERROR_FIELD = SdkField
            .<StorageGatewayError> builder(MarshallingType.SDK_POJO).getter(getter(ServiceUnavailableErrorException::error))
            .setter(setter(Builder::error)).constructor(StorageGatewayError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final StorageGatewayError error;

    private ServiceUnavailableErrorException(BuilderImpl builder) {
        super(builder);
        this.error = builder.error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * A <a>StorageGatewayError</a> that provides more information about the cause of the error.
     * </p>
     * 
     * @return A <a>StorageGatewayError</a> that provides more information about the cause of the error.
     */
    public StorageGatewayError error() {
        return error;
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceUnavailableErrorException, T> g) {
        return obj -> g.apply((ServiceUnavailableErrorException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceUnavailableErrorException>,
            StorageGatewayException.Builder {
        /**
         * <p>
         * A <a>StorageGatewayError</a> that provides more information about the cause of the error.
         * </p>
         * 
         * @param error
         *        A <a>StorageGatewayError</a> that provides more information about the cause of the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(StorageGatewayError error);

        /**
         * <p>
         * A <a>StorageGatewayError</a> that provides more information about the cause of the error.
         * </p>
         * This is a convenience that creates an instance of the {@link StorageGatewayError.Builder} avoiding the need
         * to create one manually via {@link StorageGatewayError#builder()}.
         *
         * When the {@link Consumer} completes, {@link StorageGatewayError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(StorageGatewayError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link StorageGatewayError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(StorageGatewayError)
         */
        default Builder error(Consumer<StorageGatewayError.Builder> error) {
            return error(StorageGatewayError.builder().applyMutation(error).build());
        }

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends StorageGatewayException.BuilderImpl implements Builder {
        private StorageGatewayError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceUnavailableErrorException model) {
            super(model);
            error(model.error);
        }

        public final StorageGatewayError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        @Override
        public final Builder error(StorageGatewayError error) {
            this.error = error;
            return this;
        }

        public final void setError(StorageGatewayError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ServiceUnavailableErrorException build() {
            return new ServiceUnavailableErrorException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
