/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStorediScsiVolumesResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DescribeStorediScsiVolumesResponse.Builder, DescribeStorediScsiVolumesResponse> {
    private static final SdkField<List<StorediSCSIVolume>> STOREDI_SCSI_VOLUMES_FIELD = SdkField
            .<List<StorediSCSIVolume>> builder(MarshallingType.LIST)
            .getter(getter(DescribeStorediScsiVolumesResponse::storediSCSIVolumes))
            .setter(setter(Builder::storediSCSIVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorediSCSIVolumes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorediSCSIVolume> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorediSCSIVolume::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STOREDI_SCSI_VOLUMES_FIELD));

    private final List<StorediSCSIVolume> storediSCSIVolumes;

    private DescribeStorediScsiVolumesResponse(BuilderImpl builder) {
        super(builder);
        this.storediSCSIVolumes = builder.storediSCSIVolumes;
    }

    /**
     * Returns true if the StorediSCSIVolumes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasStorediSCSIVolumes() {
        return storediSCSIVolumes != null && !(storediSCSIVolumes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes a single unit of output from <a>DescribeStorediSCSIVolumes</a>. The following fields are returned:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ChapEnabled</b>: Indicates whether mutual CHAP is enabled for the iSCSI target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>LunNumber</b>: The logical disk number.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NetworkInterfaceId</b>: The network interface ID of the stored volume that initiator use to map the stored
     * volume as an iSCSI target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>NetworkInterfacePort</b>: The port used to communicate with iSCSI targets.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PreservedExistingData</b>: Indicates if when the stored volume was created, existing data on the underlying
     * local disk was preserved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SourceSnapshotId</b>: If the stored volume was created from a snapshot, this field contains the snapshot ID
     * used, e.g. snap-1122aabb. Otherwise, this field is not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>StorediSCSIVolumes</b>: An array of StorediSCSIVolume objects where each object contains metadata about one
     * stored volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>TargetARN</b>: The Amazon Resource Name (ARN) of the volume target.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VolumeARN</b>: The Amazon Resource Name (ARN) of the stored volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VolumeDiskId</b>: The disk ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a>
     * operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VolumeId</b>: The unique identifier of the storage volume, e.g. vol-1122AABB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VolumeiSCSIAttributes</b>: An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
     * attributes for one stored volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VolumeProgress</b>: Represents the percentage complete if the volume is restoring or bootstrapping that
     * represents the percent of data transferred. This field does not appear in the response if the stored volume is
     * not restoring or bootstrapping.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VolumeSizeInBytes</b>: The size of the volume in bytes.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VolumeStatus</b>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>VolumeType</b>: One of the enumeration values describing the type of the volume. Currently, on STORED volumes
     * are supported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStorediSCSIVolumes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Describes a single unit of output from <a>DescribeStorediSCSIVolumes</a>. The following fields are
     *         returned:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ChapEnabled</b>: Indicates whether mutual CHAP is enabled for the iSCSI target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>LunNumber</b>: The logical disk number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NetworkInterfaceId</b>: The network interface ID of the stored volume that initiator use to map the
     *         stored volume as an iSCSI target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>NetworkInterfacePort</b>: The port used to communicate with iSCSI targets.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PreservedExistingData</b>: Indicates if when the stored volume was created, existing data on the
     *         underlying local disk was preserved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SourceSnapshotId</b>: If the stored volume was created from a snapshot, this field contains the
     *         snapshot ID used, e.g. snap-1122aabb. Otherwise, this field is not included.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>StorediSCSIVolumes</b>: An array of StorediSCSIVolume objects where each object contains metadata
     *         about one stored volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>TargetARN</b>: The Amazon Resource Name (ARN) of the volume target.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VolumeARN</b>: The Amazon Resource Name (ARN) of the stored volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VolumeDiskId</b>: The disk ID of the local disk that was specified in the
     *         <a>CreateStorediSCSIVolume</a> operation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VolumeId</b>: The unique identifier of the storage volume, e.g. vol-1122AABB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VolumeiSCSIAttributes</b>: An <a>VolumeiSCSIAttributes</a> object that represents a collection of
     *         iSCSI attributes for one stored volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VolumeProgress</b>: Represents the percentage complete if the volume is restoring or bootstrapping
     *         that represents the percent of data transferred. This field does not appear in the response if the stored
     *         volume is not restoring or bootstrapping.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VolumeSizeInBytes</b>: The size of the volume in bytes.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VolumeStatus</b>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>VolumeType</b>: One of the enumeration values describing the type of the volume. Currently, on STORED
     *         volumes are supported.
     *         </p>
     *         </li>
     */
    public List<StorediSCSIVolume> storediSCSIVolumes() {
        return storediSCSIVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storediSCSIVolumes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStorediScsiVolumesResponse)) {
            return false;
        }
        DescribeStorediScsiVolumesResponse other = (DescribeStorediScsiVolumesResponse) obj;
        return Objects.equals(storediSCSIVolumes(), other.storediSCSIVolumes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeStorediScsiVolumesResponse").add("StorediSCSIVolumes", storediSCSIVolumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorediSCSIVolumes":
            return Optional.ofNullable(clazz.cast(storediSCSIVolumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStorediScsiVolumesResponse, T> g) {
        return obj -> g.apply((DescribeStorediScsiVolumesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeStorediScsiVolumesResponse> {
        /**
         * <p>
         * Describes a single unit of output from <a>DescribeStorediSCSIVolumes</a>. The following fields are returned:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ChapEnabled</b>: Indicates whether mutual CHAP is enabled for the iSCSI target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>LunNumber</b>: The logical disk number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NetworkInterfaceId</b>: The network interface ID of the stored volume that initiator use to map the stored
         * volume as an iSCSI target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NetworkInterfacePort</b>: The port used to communicate with iSCSI targets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PreservedExistingData</b>: Indicates if when the stored volume was created, existing data on the
         * underlying local disk was preserved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SourceSnapshotId</b>: If the stored volume was created from a snapshot, this field contains the snapshot
         * ID used, e.g. snap-1122aabb. Otherwise, this field is not included.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>StorediSCSIVolumes</b>: An array of StorediSCSIVolume objects where each object contains metadata about
         * one stored volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TargetARN</b>: The Amazon Resource Name (ARN) of the volume target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeARN</b>: The Amazon Resource Name (ARN) of the stored volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeDiskId</b>: The disk ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a>
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeId</b>: The unique identifier of the storage volume, e.g. vol-1122AABB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeiSCSIAttributes</b>: An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
         * attributes for one stored volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeProgress</b>: Represents the percentage complete if the volume is restoring or bootstrapping that
         * represents the percent of data transferred. This field does not appear in the response if the stored volume
         * is not restoring or bootstrapping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeSizeInBytes</b>: The size of the volume in bytes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeStatus</b>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeType</b>: One of the enumeration values describing the type of the volume. Currently, on STORED
         * volumes are supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param storediSCSIVolumes
         *        Describes a single unit of output from <a>DescribeStorediSCSIVolumes</a>. The following fields are
         *        returned:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ChapEnabled</b>: Indicates whether mutual CHAP is enabled for the iSCSI target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>LunNumber</b>: The logical disk number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NetworkInterfaceId</b>: The network interface ID of the stored volume that initiator use to map the
         *        stored volume as an iSCSI target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NetworkInterfacePort</b>: The port used to communicate with iSCSI targets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PreservedExistingData</b>: Indicates if when the stored volume was created, existing data on the
         *        underlying local disk was preserved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SourceSnapshotId</b>: If the stored volume was created from a snapshot, this field contains the
         *        snapshot ID used, e.g. snap-1122aabb. Otherwise, this field is not included.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>StorediSCSIVolumes</b>: An array of StorediSCSIVolume objects where each object contains metadata
         *        about one stored volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TargetARN</b>: The Amazon Resource Name (ARN) of the volume target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeARN</b>: The Amazon Resource Name (ARN) of the stored volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeDiskId</b>: The disk ID of the local disk that was specified in the
         *        <a>CreateStorediSCSIVolume</a> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeId</b>: The unique identifier of the storage volume, e.g. vol-1122AABB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeiSCSIAttributes</b>: An <a>VolumeiSCSIAttributes</a> object that represents a collection of
         *        iSCSI attributes for one stored volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeProgress</b>: Represents the percentage complete if the volume is restoring or bootstrapping
         *        that represents the percent of data transferred. This field does not appear in the response if the
         *        stored volume is not restoring or bootstrapping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeSizeInBytes</b>: The size of the volume in bytes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeStatus</b>: One of the <code>VolumeStatus</code> values that indicates the state of the
         *        volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeType</b>: One of the enumeration values describing the type of the volume. Currently, on
         *        STORED volumes are supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storediSCSIVolumes(Collection<StorediSCSIVolume> storediSCSIVolumes);

        /**
         * <p>
         * Describes a single unit of output from <a>DescribeStorediSCSIVolumes</a>. The following fields are returned:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ChapEnabled</b>: Indicates whether mutual CHAP is enabled for the iSCSI target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>LunNumber</b>: The logical disk number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NetworkInterfaceId</b>: The network interface ID of the stored volume that initiator use to map the stored
         * volume as an iSCSI target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NetworkInterfacePort</b>: The port used to communicate with iSCSI targets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PreservedExistingData</b>: Indicates if when the stored volume was created, existing data on the
         * underlying local disk was preserved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SourceSnapshotId</b>: If the stored volume was created from a snapshot, this field contains the snapshot
         * ID used, e.g. snap-1122aabb. Otherwise, this field is not included.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>StorediSCSIVolumes</b>: An array of StorediSCSIVolume objects where each object contains metadata about
         * one stored volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TargetARN</b>: The Amazon Resource Name (ARN) of the volume target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeARN</b>: The Amazon Resource Name (ARN) of the stored volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeDiskId</b>: The disk ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a>
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeId</b>: The unique identifier of the storage volume, e.g. vol-1122AABB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeiSCSIAttributes</b>: An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
         * attributes for one stored volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeProgress</b>: Represents the percentage complete if the volume is restoring or bootstrapping that
         * represents the percent of data transferred. This field does not appear in the response if the stored volume
         * is not restoring or bootstrapping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeSizeInBytes</b>: The size of the volume in bytes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeStatus</b>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeType</b>: One of the enumeration values describing the type of the volume. Currently, on STORED
         * volumes are supported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param storediSCSIVolumes
         *        Describes a single unit of output from <a>DescribeStorediSCSIVolumes</a>. The following fields are
         *        returned:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ChapEnabled</b>: Indicates whether mutual CHAP is enabled for the iSCSI target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>LunNumber</b>: The logical disk number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NetworkInterfaceId</b>: The network interface ID of the stored volume that initiator use to map the
         *        stored volume as an iSCSI target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>NetworkInterfacePort</b>: The port used to communicate with iSCSI targets.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PreservedExistingData</b>: Indicates if when the stored volume was created, existing data on the
         *        underlying local disk was preserved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SourceSnapshotId</b>: If the stored volume was created from a snapshot, this field contains the
         *        snapshot ID used, e.g. snap-1122aabb. Otherwise, this field is not included.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>StorediSCSIVolumes</b>: An array of StorediSCSIVolume objects where each object contains metadata
         *        about one stored volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>TargetARN</b>: The Amazon Resource Name (ARN) of the volume target.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeARN</b>: The Amazon Resource Name (ARN) of the stored volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeDiskId</b>: The disk ID of the local disk that was specified in the
         *        <a>CreateStorediSCSIVolume</a> operation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeId</b>: The unique identifier of the storage volume, e.g. vol-1122AABB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeiSCSIAttributes</b>: An <a>VolumeiSCSIAttributes</a> object that represents a collection of
         *        iSCSI attributes for one stored volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeProgress</b>: Represents the percentage complete if the volume is restoring or bootstrapping
         *        that represents the percent of data transferred. This field does not appear in the response if the
         *        stored volume is not restoring or bootstrapping.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeSizeInBytes</b>: The size of the volume in bytes.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeStatus</b>: One of the <code>VolumeStatus</code> values that indicates the state of the
         *        volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>VolumeType</b>: One of the enumeration values describing the type of the volume. Currently, on
         *        STORED volumes are supported.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storediSCSIVolumes(StorediSCSIVolume... storediSCSIVolumes);

        /**
         * <p>
         * Describes a single unit of output from <a>DescribeStorediSCSIVolumes</a>. The following fields are returned:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ChapEnabled</b>: Indicates whether mutual CHAP is enabled for the iSCSI target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>LunNumber</b>: The logical disk number.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NetworkInterfaceId</b>: The network interface ID of the stored volume that initiator use to map the stored
         * volume as an iSCSI target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>NetworkInterfacePort</b>: The port used to communicate with iSCSI targets.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PreservedExistingData</b>: Indicates if when the stored volume was created, existing data on the
         * underlying local disk was preserved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SourceSnapshotId</b>: If the stored volume was created from a snapshot, this field contains the snapshot
         * ID used, e.g. snap-1122aabb. Otherwise, this field is not included.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>StorediSCSIVolumes</b>: An array of StorediSCSIVolume objects where each object contains metadata about
         * one stored volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>TargetARN</b>: The Amazon Resource Name (ARN) of the volume target.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeARN</b>: The Amazon Resource Name (ARN) of the stored volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeDiskId</b>: The disk ID of the local disk that was specified in the <a>CreateStorediSCSIVolume</a>
         * operation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeId</b>: The unique identifier of the storage volume, e.g. vol-1122AABB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeiSCSIAttributes</b>: An <a>VolumeiSCSIAttributes</a> object that represents a collection of iSCSI
         * attributes for one stored volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeProgress</b>: Represents the percentage complete if the volume is restoring or bootstrapping that
         * represents the percent of data transferred. This field does not appear in the response if the stored volume
         * is not restoring or bootstrapping.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeSizeInBytes</b>: The size of the volume in bytes.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeStatus</b>: One of the <code>VolumeStatus</code> values that indicates the state of the volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>VolumeType</b>: One of the enumeration values describing the type of the volume. Currently, on STORED
         * volumes are supported.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<StorediSCSIVolume>.Builder} avoiding the
         * need to create one manually via {@link List<StorediSCSIVolume>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorediSCSIVolume>.Builder#build()} is called immediately
         * and its result is passed to {@link #storediSCSIVolumes(List<StorediSCSIVolume>)}.
         * 
         * @param storediSCSIVolumes
         *        a consumer that will call methods on {@link List<StorediSCSIVolume>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storediSCSIVolumes(List<StorediSCSIVolume>)
         */
        Builder storediSCSIVolumes(Consumer<StorediSCSIVolume.Builder>... storediSCSIVolumes);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private List<StorediSCSIVolume> storediSCSIVolumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStorediScsiVolumesResponse model) {
            super(model);
            storediSCSIVolumes(model.storediSCSIVolumes);
        }

        public final Collection<StorediSCSIVolume.Builder> getStorediSCSIVolumes() {
            return storediSCSIVolumes != null ? storediSCSIVolumes.stream().map(StorediSCSIVolume::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storediSCSIVolumes(Collection<StorediSCSIVolume> storediSCSIVolumes) {
            this.storediSCSIVolumes = StorediSCSIVolumesCopier.copy(storediSCSIVolumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storediSCSIVolumes(StorediSCSIVolume... storediSCSIVolumes) {
            storediSCSIVolumes(Arrays.asList(storediSCSIVolumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storediSCSIVolumes(Consumer<StorediSCSIVolume.Builder>... storediSCSIVolumes) {
            storediSCSIVolumes(Stream.of(storediSCSIVolumes).map(c -> StorediSCSIVolume.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setStorediSCSIVolumes(Collection<StorediSCSIVolume.BuilderImpl> storediSCSIVolumes) {
            this.storediSCSIVolumes = StorediSCSIVolumesCopier.copyFromBuilder(storediSCSIVolumes);
        }

        @Override
        public DescribeStorediScsiVolumesResponse build() {
            return new DescribeStorediScsiVolumesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
