/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A JSON object containing the following fields:
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteChapCredentialsResponse extends StorageGatewayResponse implements
        ToCopyableBuilder<DeleteChapCredentialsResponse.Builder, DeleteChapCredentialsResponse> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteChapCredentialsResponse::targetARN)).setter(setter(Builder::targetARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetARN").build()).build();

    private static final SdkField<String> INITIATOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteChapCredentialsResponse::initiatorName)).setter(setter(Builder::initiatorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatorName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            INITIATOR_NAME_FIELD));

    private final String targetARN;

    private final String initiatorName;

    private DeleteChapCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.targetARN = builder.targetARN;
        this.initiatorName = builder.initiatorName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the target.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the target.
     */
    public String targetARN() {
        return targetARN;
    }

    /**
     * <p>
     * The iSCSI initiator that connects to the target.
     * </p>
     * 
     * @return The iSCSI initiator that connects to the target.
     */
    public String initiatorName() {
        return initiatorName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(targetARN());
        hashCode = 31 * hashCode + Objects.hashCode(initiatorName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteChapCredentialsResponse)) {
            return false;
        }
        DeleteChapCredentialsResponse other = (DeleteChapCredentialsResponse) obj;
        return Objects.equals(targetARN(), other.targetARN()) && Objects.equals(initiatorName(), other.initiatorName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteChapCredentialsResponse").add("TargetARN", targetARN())
                .add("InitiatorName", initiatorName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetARN":
            return Optional.ofNullable(clazz.cast(targetARN()));
        case "InitiatorName":
            return Optional.ofNullable(clazz.cast(initiatorName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteChapCredentialsResponse, T> g) {
        return obj -> g.apply((DeleteChapCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteChapCredentialsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the target.
         * </p>
         * 
         * @param targetARN
         *        The Amazon Resource Name (ARN) of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetARN(String targetARN);

        /**
         * <p>
         * The iSCSI initiator that connects to the target.
         * </p>
         * 
         * @param initiatorName
         *        The iSCSI initiator that connects to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatorName(String initiatorName);
    }

    static final class BuilderImpl extends StorageGatewayResponse.BuilderImpl implements Builder {
        private String targetARN;

        private String initiatorName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteChapCredentialsResponse model) {
            super(model);
            targetARN(model.targetARN);
            initiatorName(model.initiatorName);
        }

        public final String getTargetARN() {
            return targetARN;
        }

        @Override
        public final Builder targetARN(String targetARN) {
            this.targetARN = targetARN;
            return this;
        }

        public final void setTargetARN(String targetARN) {
            this.targetARN = targetARN;
        }

        public final String getInitiatorName() {
            return initiatorName;
        }

        @Override
        public final Builder initiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
            return this;
        }

        public final void setInitiatorName(String initiatorName) {
            this.initiatorName = initiatorName;
        }

        @Override
        public DeleteChapCredentialsResponse build() {
            return new DeleteChapCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
