/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.storagegateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * AttachVolumeInput
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AttachVolumeRequest extends StorageGatewayRequest implements
        ToCopyableBuilder<AttachVolumeRequest.Builder, AttachVolumeRequest> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachVolumeRequest::gatewayARN)).setter(setter(Builder::gatewayARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayARN").build()).build();

    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachVolumeRequest::targetName)).setter(setter(Builder::targetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetName").build()).build();

    private static final SdkField<String> VOLUME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachVolumeRequest::volumeARN)).setter(setter(Builder::volumeARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeARN").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachVolumeRequest::networkInterfaceId)).setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<String> DISK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AttachVolumeRequest::diskId)).setter(setter(Builder::diskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD,
            TARGET_NAME_FIELD, VOLUME_ARN_FIELD, NETWORK_INTERFACE_ID_FIELD, DISK_ID_FIELD));

    private final String gatewayARN;

    private final String targetName;

    private final String volumeARN;

    private final String networkInterfaceId;

    private final String diskId;

    private AttachVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.gatewayARN = builder.gatewayARN;
        this.targetName = builder.targetName;
        this.volumeARN = builder.volumeARN;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.diskId = builder.diskId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.
     */
    public String gatewayARN() {
        return gatewayARN;
    }

    /**
     * <p>
     * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target ARN.
     * For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of
     * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
     * . The target name must be unique across all volumes on a gateway.
     * </p>
     * <p>
     * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the new
     * target name.
     * </p>
     * 
     * @return The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the
     *         target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN
     *         of
     *         <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
     *         . The target name must be unique across all volumes on a gateway.</p>
     *         <p>
     *         If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as
     *         the new target name.
     */
    public String targetName() {
        return targetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
     */
    public String volumeARN() {
        return volumeARN;
    }

    /**
     * <p>
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted. Use
     * <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.
     * </p>
     * <p>
     * Valid Values: A valid IP address.
     * </p>
     * 
     * @return The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are
     *         accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a
     *         gateway.</p>
     *         <p>
     *         Valid Values: A valid IP address.
     */
    public String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The unique device ID or other distinguishing data that identifies the local disk used to create the volume. This
     * value is only required when you are attaching a stored volume.
     * </p>
     * 
     * @return The unique device ID or other distinguishing data that identifies the local disk used to create the
     *         volume. This value is only required when you are attaching a stored volume.
     */
    public String diskId() {
        return diskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayARN());
        hashCode = 31 * hashCode + Objects.hashCode(targetName());
        hashCode = 31 * hashCode + Objects.hashCode(volumeARN());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(diskId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachVolumeRequest)) {
            return false;
        }
        AttachVolumeRequest other = (AttachVolumeRequest) obj;
        return Objects.equals(gatewayARN(), other.gatewayARN()) && Objects.equals(targetName(), other.targetName())
                && Objects.equals(volumeARN(), other.volumeARN())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(diskId(), other.diskId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AttachVolumeRequest").add("GatewayARN", gatewayARN()).add("TargetName", targetName())
                .add("VolumeARN", volumeARN()).add("NetworkInterfaceId", networkInterfaceId()).add("DiskId", diskId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GatewayARN":
            return Optional.ofNullable(clazz.cast(gatewayARN()));
        case "TargetName":
            return Optional.ofNullable(clazz.cast(targetName()));
        case "VolumeARN":
            return Optional.ofNullable(clazz.cast(volumeARN()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "DiskId":
            return Optional.ofNullable(clazz.cast(diskId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AttachVolumeRequest, T> g) {
        return obj -> g.apply((AttachVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends StorageGatewayRequest.Builder, SdkPojo, CopyableBuilder<Builder, AttachVolumeRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.
         * </p>
         * 
         * @param gatewayARN
         *        The Amazon Resource Name (ARN) of the gateway that you want to attach the volume to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayARN(String gatewayARN);

        /**
         * <p>
         * The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the target
         * ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target ARN of
         * <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
         * . The target name must be unique across all volumes on a gateway.
         * </p>
         * <p>
         * If you don't specify a value, Storage Gateway uses the value that was previously used for this volume as the
         * new target name.
         * </p>
         * 
         * @param targetName
         *        The name of the iSCSI target used by an initiator to connect to a volume and used as a suffix for the
         *        target ARN. For example, specifying <code>TargetName</code> as <i>myvolume</i> results in the target
         *        ARN of
         *        <code>arn:aws:storagegateway:us-east-2:111122223333:gateway/sgw-12A3456B/target/iqn.1997-05.com.amazon:myvolume</code>
         *        . The target name must be unique across all volumes on a gateway.</p>
         *        <p>
         *        If you don't specify a value, Storage Gateway uses the value that was previously used for this volume
         *        as the new target name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetName(String targetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
         * </p>
         * 
         * @param volumeARN
         *        The Amazon Resource Name (ARN) of the volume to attach to the specified gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeARN(String volumeARN);

        /**
         * <p>
         * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
         * Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a gateway.
         * </p>
         * <p>
         * Valid Values: A valid IP address.
         * </p>
         * 
         * @param networkInterfaceId
         *        The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are
         *        accepted. Use <a>DescribeGatewayInformation</a> to get a list of the network interfaces available on a
         *        gateway.</p>
         *        <p>
         *        Valid Values: A valid IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The unique device ID or other distinguishing data that identifies the local disk used to create the volume.
         * This value is only required when you are attaching a stored volume.
         * </p>
         * 
         * @param diskId
         *        The unique device ID or other distinguishing data that identifies the local disk used to create the
         *        volume. This value is only required when you are attaching a stored volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskId(String diskId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends StorageGatewayRequest.BuilderImpl implements Builder {
        private String gatewayARN;

        private String targetName;

        private String volumeARN;

        private String networkInterfaceId;

        private String diskId;

        private BuilderImpl() {
        }

        private BuilderImpl(AttachVolumeRequest model) {
            super(model);
            gatewayARN(model.gatewayARN);
            targetName(model.targetName);
            volumeARN(model.volumeARN);
            networkInterfaceId(model.networkInterfaceId);
            diskId(model.diskId);
        }

        public final String getGatewayARN() {
            return gatewayARN;
        }

        @Override
        public final Builder gatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
            return this;
        }

        public final void setGatewayARN(String gatewayARN) {
            this.gatewayARN = gatewayARN;
        }

        public final String getTargetName() {
            return targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        public final String getVolumeARN() {
            return volumeARN;
        }

        @Override
        public final Builder volumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
            return this;
        }

        public final void setVolumeARN(String volumeARN) {
            this.volumeARN = volumeARN;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getDiskId() {
            return diskId;
        }

        @Override
        public final Builder diskId(String diskId) {
            this.diskId = diskId;
            return this;
        }

        public final void setDiskId(String diskId) {
            this.diskId = diskId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AttachVolumeRequest build() {
            return new AttachVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
