/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the client is not currently authorized to make the request. This can happen when a
 * <code>clientId</code> is not issued for a public client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UnauthorizedClientException extends SsoOidcException implements
        ToCopyableBuilder<UnauthorizedClientException.Builder, UnauthorizedClientException> {
    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(UnauthorizedClientException::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> ERROR_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorDescription").getter(getter(UnauthorizedClientException::errorDescription))
            .setter(setter(Builder::errorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error_description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD,
            ERROR_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String error;

    private final String errorDescription;

    private UnauthorizedClientException(BuilderImpl builder) {
        super(builder);
        this.error = builder.error;
        this.errorDescription = builder.errorDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Single error code. For this exception the value will be <code>unauthorized_client</code>.
     * </p>
     * 
     * @return Single error code. For this exception the value will be <code>unauthorized_client</code>.
     */
    public String error() {
        return error;
    }

    /**
     * <p>
     * Human-readable text providing additional information, used to assist the client developer in understanding the
     * error that occurred.
     * </p>
     * 
     * @return Human-readable text providing additional information, used to assist the client developer in
     *         understanding the error that occurred.
     * @deprecated Use {@link #errorDescription()}
     */
    @Deprecated
    public String error_description() {
        return errorDescription;
    }

    /**
     * <p>
     * Human-readable text providing additional information, used to assist the client developer in understanding the
     * error that occurred.
     * </p>
     * 
     * @return Human-readable text providing additional information, used to assist the client developer in
     *         understanding the error that occurred.
     */
    public String errorDescription() {
        return errorDescription;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("error", ERROR_FIELD);
        map.put("error_description", ERROR_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UnauthorizedClientException, T> g) {
        return obj -> g.apply((UnauthorizedClientException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UnauthorizedClientException>, SsoOidcException.Builder {
        /**
         * <p>
         * Single error code. For this exception the value will be <code>unauthorized_client</code>.
         * </p>
         * 
         * @param error
         *        Single error code. For this exception the value will be <code>unauthorized_client</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * Human-readable text providing additional information, used to assist the client developer in understanding
         * the error that occurred.
         * </p>
         * 
         * @param errorDescription
         *        Human-readable text providing additional information, used to assist the client developer in
         *        understanding the error that occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDescription(String errorDescription);

        /**
         * <p>
         * Human-readable text providing additional information, used to assist the client developer in understanding
         * the error that occurred.
         * </p>
         * 
         * @param errorDescription
         *        Human-readable text providing additional information, used to assist the client developer in
         *        understanding the error that occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated Use {@link #errorDescription(String)}
         */
        @Deprecated
        Builder error_description(String errorDescription);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends SsoOidcException.BuilderImpl implements Builder {
        private String error;

        private String errorDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(UnauthorizedClientException model) {
            super(model);
            error(model.error);
            errorDescription(model.errorDescription);
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getErrorDescription() {
            return errorDescription;
        }

        public final void setErrorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        /**
         * @deprecated Use {@link #setErrorDescription} instead
         */
        @Deprecated
        public final void setError_description(String errorDescription) {
            this.errorDescription = errorDescription;
        }

        @Override
        public final Builder errorDescription(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        @Override
        public final Builder error_description(String errorDescription) {
            this.errorDescription = errorDescription;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public UnauthorizedClientException build() {
            return new UnauthorizedClientException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
