/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ssooidc.DefaultSsoOidcClientBuilder;
import software.amazon.awssdk.services.ssooidc.SsoOidcClientBuilder;
import software.amazon.awssdk.services.ssooidc.SsoOidcServiceClientConfiguration;
import software.amazon.awssdk.services.ssooidc.model.AccessDeniedException;
import software.amazon.awssdk.services.ssooidc.model.AuthorizationPendingException;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest;
import software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse;
import software.amazon.awssdk.services.ssooidc.model.ExpiredTokenException;
import software.amazon.awssdk.services.ssooidc.model.InternalServerException;
import software.amazon.awssdk.services.ssooidc.model.InvalidClientException;
import software.amazon.awssdk.services.ssooidc.model.InvalidClientMetadataException;
import software.amazon.awssdk.services.ssooidc.model.InvalidGrantException;
import software.amazon.awssdk.services.ssooidc.model.InvalidRequestException;
import software.amazon.awssdk.services.ssooidc.model.InvalidScopeException;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest;
import software.amazon.awssdk.services.ssooidc.model.RegisterClientResponse;
import software.amazon.awssdk.services.ssooidc.model.SlowDownException;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcException;
import software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationRequest;
import software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse;
import software.amazon.awssdk.services.ssooidc.model.UnauthorizedClientException;
import software.amazon.awssdk.services.ssooidc.model.UnsupportedGrantTypeException;

@SdkPublicApi
@ThreadSafe
public interface SsoOidcClient
extends AwsClient {
    public static final String SERVICE_NAME = "awsssooidc";
    public static final String SERVICE_METADATA_ID = "oidc";

    default public CreateTokenResponse createToken(CreateTokenRequest createTokenRequest) throws InvalidRequestException, InvalidClientException, InvalidGrantException, UnauthorizedClientException, UnsupportedGrantTypeException, InvalidScopeException, AuthorizationPendingException, SlowDownException, AccessDeniedException, ExpiredTokenException, InternalServerException, AwsServiceException, SdkClientException, SsoOidcException {
        throw new UnsupportedOperationException();
    }

    default public CreateTokenResponse createToken(Consumer<CreateTokenRequest.Builder> createTokenRequest) throws InvalidRequestException, InvalidClientException, InvalidGrantException, UnauthorizedClientException, UnsupportedGrantTypeException, InvalidScopeException, AuthorizationPendingException, SlowDownException, AccessDeniedException, ExpiredTokenException, InternalServerException, AwsServiceException, SdkClientException, SsoOidcException {
        return this.createToken((CreateTokenRequest)((Object)((CreateTokenRequest.Builder)CreateTokenRequest.builder().applyMutation(createTokenRequest)).build()));
    }

    default public RegisterClientResponse registerClient(RegisterClientRequest registerClientRequest) throws InvalidRequestException, InvalidScopeException, InvalidClientMetadataException, InternalServerException, AwsServiceException, SdkClientException, SsoOidcException {
        throw new UnsupportedOperationException();
    }

    default public RegisterClientResponse registerClient(Consumer<RegisterClientRequest.Builder> registerClientRequest) throws InvalidRequestException, InvalidScopeException, InvalidClientMetadataException, InternalServerException, AwsServiceException, SdkClientException, SsoOidcException {
        return this.registerClient((RegisterClientRequest)((Object)((RegisterClientRequest.Builder)RegisterClientRequest.builder().applyMutation(registerClientRequest)).build()));
    }

    default public StartDeviceAuthorizationResponse startDeviceAuthorization(StartDeviceAuthorizationRequest startDeviceAuthorizationRequest) throws InvalidRequestException, InvalidClientException, UnauthorizedClientException, SlowDownException, InternalServerException, AwsServiceException, SdkClientException, SsoOidcException {
        throw new UnsupportedOperationException();
    }

    default public StartDeviceAuthorizationResponse startDeviceAuthorization(Consumer<StartDeviceAuthorizationRequest.Builder> startDeviceAuthorizationRequest) throws InvalidRequestException, InvalidClientException, UnauthorizedClientException, SlowDownException, InternalServerException, AwsServiceException, SdkClientException, SsoOidcException {
        return this.startDeviceAuthorization((StartDeviceAuthorizationRequest)((Object)((StartDeviceAuthorizationRequest.Builder)StartDeviceAuthorizationRequest.builder().applyMutation(startDeviceAuthorizationRequest)).build()));
    }

    public static SsoOidcClient create() {
        return (SsoOidcClient)SsoOidcClient.builder().build();
    }

    public static SsoOidcClientBuilder builder() {
        return new DefaultSsoOidcClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    public SsoOidcServiceClientConfiguration serviceClientConfiguration();
}

