/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDeviceAuthorizationRequest
extends SsoOidcRequest
implements ToCopyableBuilder<Builder, StartDeviceAuthorizationRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartDeviceAuthorizationRequest.getter(StartDeviceAuthorizationRequest::clientId)).setter(StartDeviceAuthorizationRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()}).build();
    private static final SdkField<String> CLIENT_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartDeviceAuthorizationRequest.getter(StartDeviceAuthorizationRequest::clientSecret)).setter(StartDeviceAuthorizationRequest.setter(Builder::clientSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSecret").build()}).build();
    private static final SdkField<String> START_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartDeviceAuthorizationRequest.getter(StartDeviceAuthorizationRequest::startUrl)).setter(StartDeviceAuthorizationRequest.setter(Builder::startUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD, CLIENT_SECRET_FIELD, START_URL_FIELD));
    private final String clientId;
    private final String clientSecret;
    private final String startUrl;

    private StartDeviceAuthorizationRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.startUrl = builder.startUrl;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String startUrl() {
        return this.startUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.startUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDeviceAuthorizationRequest)) {
            return false;
        }
        StartDeviceAuthorizationRequest other = (StartDeviceAuthorizationRequest)((Object)obj);
        return Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.clientSecret(), other.clientSecret()) && Objects.equals(this.startUrl(), other.startUrl());
    }

    public String toString() {
        return ToString.builder((String)"StartDeviceAuthorizationRequest").add("ClientId", (Object)this.clientId()).add("ClientSecret", (Object)this.clientSecret()).add("StartUrl", (Object)this.startUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "clientSecret": {
                return Optional.ofNullable(clazz.cast(this.clientSecret()));
            }
            case "startUrl": {
                return Optional.ofNullable(clazz.cast(this.startUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDeviceAuthorizationRequest, T> g) {
        return obj -> g.apply((StartDeviceAuthorizationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcRequest.BuilderImpl
    implements Builder {
        private String clientId;
        private String clientSecret;
        private String startUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDeviceAuthorizationRequest model) {
            super(model);
            this.clientId(model.clientId);
            this.clientSecret(model.clientSecret);
            this.startUrl(model.startUrl);
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getClientSecret() {
            return this.clientSecret;
        }

        @Override
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public final void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public final String getStartUrl() {
            return this.startUrl;
        }

        @Override
        public final Builder startUrl(String startUrl) {
            this.startUrl = startUrl;
            return this;
        }

        public final void setStartUrl(String startUrl) {
            this.startUrl = startUrl;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDeviceAuthorizationRequest build() {
            return new StartDeviceAuthorizationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoOidcRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDeviceAuthorizationRequest> {
        public Builder clientId(String var1);

        public Builder clientSecret(String var1);

        public Builder startUrl(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

