/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssooidc.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssooidc.model.SsoOidcResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTokenResponse
extends SsoOidcResponse
implements ToCopyableBuilder<Builder, CreateTokenResponse> {
    private static final SdkField<String> ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTokenResponse.getter(CreateTokenResponse::accessToken)).setter(CreateTokenResponse.setter(Builder::accessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessToken").build()}).build();
    private static final SdkField<String> TOKEN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTokenResponse.getter(CreateTokenResponse::tokenType)).setter(CreateTokenResponse.setter(Builder::tokenType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenType").build()}).build();
    private static final SdkField<Integer> EXPIRES_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateTokenResponse.getter(CreateTokenResponse::expiresIn)).setter(CreateTokenResponse.setter(Builder::expiresIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresIn").build()}).build();
    private static final SdkField<String> REFRESH_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTokenResponse.getter(CreateTokenResponse::refreshToken)).setter(CreateTokenResponse.setter(Builder::refreshToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshToken").build()}).build();
    private static final SdkField<String> ID_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTokenResponse.getter(CreateTokenResponse::idToken)).setter(CreateTokenResponse.setter(Builder::idToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TOKEN_FIELD, TOKEN_TYPE_FIELD, EXPIRES_IN_FIELD, REFRESH_TOKEN_FIELD, ID_TOKEN_FIELD));
    private final String accessToken;
    private final String tokenType;
    private final Integer expiresIn;
    private final String refreshToken;
    private final String idToken;

    private CreateTokenResponse(BuilderImpl builder) {
        super(builder);
        this.accessToken = builder.accessToken;
        this.tokenType = builder.tokenType;
        this.expiresIn = builder.expiresIn;
        this.refreshToken = builder.refreshToken;
        this.idToken = builder.idToken;
    }

    public String accessToken() {
        return this.accessToken;
    }

    public String tokenType() {
        return this.tokenType;
    }

    public Integer expiresIn() {
        return this.expiresIn;
    }

    public String refreshToken() {
        return this.refreshToken;
    }

    public String idToken() {
        return this.idToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenType());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.idToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTokenResponse)) {
            return false;
        }
        CreateTokenResponse other = (CreateTokenResponse)((Object)obj);
        return Objects.equals(this.accessToken(), other.accessToken()) && Objects.equals(this.tokenType(), other.tokenType()) && Objects.equals(this.expiresIn(), other.expiresIn()) && Objects.equals(this.refreshToken(), other.refreshToken()) && Objects.equals(this.idToken(), other.idToken());
    }

    public String toString() {
        return ToString.builder((String)"CreateTokenResponse").add("AccessToken", (Object)this.accessToken()).add("TokenType", (Object)this.tokenType()).add("ExpiresIn", (Object)this.expiresIn()).add("RefreshToken", (Object)this.refreshToken()).add("IdToken", (Object)this.idToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessToken": {
                return Optional.ofNullable(clazz.cast(this.accessToken()));
            }
            case "tokenType": {
                return Optional.ofNullable(clazz.cast(this.tokenType()));
            }
            case "expiresIn": {
                return Optional.ofNullable(clazz.cast(this.expiresIn()));
            }
            case "refreshToken": {
                return Optional.ofNullable(clazz.cast(this.refreshToken()));
            }
            case "idToken": {
                return Optional.ofNullable(clazz.cast(this.idToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTokenResponse, T> g) {
        return obj -> g.apply((CreateTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoOidcResponse.BuilderImpl
    implements Builder {
        private String accessToken;
        private String tokenType;
        private Integer expiresIn;
        private String refreshToken;
        private String idToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTokenResponse model) {
            super(model);
            this.accessToken(model.accessToken);
            this.tokenType(model.tokenType);
            this.expiresIn(model.expiresIn);
            this.refreshToken(model.refreshToken);
            this.idToken(model.idToken);
        }

        public final String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public final Builder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public final String getTokenType() {
            return this.tokenType;
        }

        @Override
        public final Builder tokenType(String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public final void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }

        public final Integer getExpiresIn() {
            return this.expiresIn;
        }

        @Override
        public final Builder expiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public final void setExpiresIn(Integer expiresIn) {
            this.expiresIn = expiresIn;
        }

        public final String getRefreshToken() {
            return this.refreshToken;
        }

        @Override
        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public final void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public final String getIdToken() {
            return this.idToken;
        }

        @Override
        public final Builder idToken(String idToken) {
            this.idToken = idToken;
            return this;
        }

        public final void setIdToken(String idToken) {
            this.idToken = idToken;
        }

        @Override
        public CreateTokenResponse build() {
            return new CreateTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoOidcResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTokenResponse> {
        public Builder accessToken(String var1);

        public Builder tokenType(String var1);

        public Builder expiresIn(Integer var1);

        public Builder refreshToken(String var1);

        public Builder idToken(String var1);
    }
}

