/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstanceResponse extends SsoAdminResponse implements
        ToCopyableBuilder<CreateInstanceResponse.Builder, CreateInstanceResponse> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceArn").getter(getter(CreateInstanceResponse::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String instanceArn;

    private CreateInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
    }

    /**
     * <p>
     * The ARN of the instance of IAM Identity Center under which the operation will run.
     * </p>
     * <p>
     * For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
     * Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The ARN of the instance of IAM Identity Center under which the operation will run. </p>
     *         <p>
     *         For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     *         Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services
     *         General Reference</i>.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceResponse)) {
            return false;
        }
        CreateInstanceResponse other = (CreateInstanceResponse) obj;
        return Objects.equals(instanceArn(), other.instanceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInstanceResponse").add("InstanceArn", instanceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceResponse, T> g) {
        return obj -> g.apply((CreateInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsoAdminResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateInstanceResponse> {
        /**
         * <p>
         * The ARN of the instance of IAM Identity Center under which the operation will run.
         * </p>
         * <p>
         * For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services General
         * Reference</i>.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the instance of IAM Identity Center under which the operation will run. </p>
         *        <p>
         *        For more information about ARNs, see <a href="/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         *        Resource Names (ARNs) and Amazon Web Services Service Namespaces</a> in the <i>Amazon Web Services
         *        General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);
    }

    static final class BuilderImpl extends SsoAdminResponse.BuilderImpl implements Builder {
        private String instanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceResponse model) {
            super(model);
            instanceArn(model.instanceArn);
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        @Override
        public CreateInstanceResponse build() {
            return new CreateInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
