/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.ApplicationStatus;
import software.amazon.awssdk.services.ssoadmin.model.PortalOptions;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, DescribeApplicationResponse> {
    private static final SdkField<String> APPLICATION_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationAccount").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationAccount)).setter(DescribeApplicationResponse.setter(Builder::applicationAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationAccount").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationArn").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationArn)).setter(DescribeApplicationResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationArn").build()}).build();
    private static final SdkField<String> APPLICATION_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationProviderArn").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationProviderArn)).setter(DescribeApplicationResponse.setter(Builder::applicationProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationProviderArn").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDate").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::createdDate)).setter(DescribeApplicationResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::description)).setter(DescribeApplicationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::instanceArn)).setter(DescribeApplicationResponse.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::name)).setter(DescribeApplicationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<PortalOptions> PORTAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PortalOptions").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::portalOptions)).setter(DescribeApplicationResponse.setter(Builder::portalOptions)).constructor(PortalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortalOptions").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::statusAsString)).setter(DescribeApplicationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ACCOUNT_FIELD, APPLICATION_ARN_FIELD, APPLICATION_PROVIDER_ARN_FIELD, CREATED_DATE_FIELD, DESCRIPTION_FIELD, INSTANCE_ARN_FIELD, NAME_FIELD, PORTAL_OPTIONS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeApplicationResponse.memberNameToFieldInitializer();
    private final String applicationAccount;
    private final String applicationArn;
    private final String applicationProviderArn;
    private final Instant createdDate;
    private final String description;
    private final String instanceArn;
    private final String name;
    private final PortalOptions portalOptions;
    private final String status;

    private DescribeApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationAccount = builder.applicationAccount;
        this.applicationArn = builder.applicationArn;
        this.applicationProviderArn = builder.applicationProviderArn;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.instanceArn = builder.instanceArn;
        this.name = builder.name;
        this.portalOptions = builder.portalOptions;
        this.status = builder.status;
    }

    public final String applicationAccount() {
        return this.applicationAccount;
    }

    public final String applicationArn() {
        return this.applicationArn;
    }

    public final String applicationProviderArn() {
        return this.applicationProviderArn;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final String description() {
        return this.description;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String name() {
        return this.name;
    }

    public final PortalOptions portalOptions() {
        return this.portalOptions;
    }

    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationResponse)) {
            return false;
        }
        DescribeApplicationResponse other = (DescribeApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationAccount(), other.applicationAccount()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.applicationProviderArn(), other.applicationProviderArn()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.portalOptions(), other.portalOptions()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationResponse").add("ApplicationAccount", (Object)this.applicationAccount()).add("ApplicationArn", (Object)this.applicationArn()).add("ApplicationProviderArn", (Object)this.applicationProviderArn()).add("CreatedDate", (Object)this.createdDate()).add("Description", (Object)this.description()).add("InstanceArn", (Object)this.instanceArn()).add("Name", (Object)this.name()).add("PortalOptions", (Object)this.portalOptions()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationAccount": {
                return Optional.ofNullable(clazz.cast(this.applicationAccount()));
            }
            case "ApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "ApplicationProviderArn": {
                return Optional.ofNullable(clazz.cast(this.applicationProviderArn()));
            }
            case "CreatedDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PortalOptions": {
                return Optional.ofNullable(clazz.cast(this.portalOptions()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ApplicationAccount", APPLICATION_ACCOUNT_FIELD);
        map.put("ApplicationArn", APPLICATION_ARN_FIELD);
        map.put("ApplicationProviderArn", APPLICATION_PROVIDER_ARN_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("PortalOptions", PORTAL_OPTIONS_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationResponse, T> g) {
        return obj -> g.apply((DescribeApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private String applicationAccount;
        private String applicationArn;
        private String applicationProviderArn;
        private Instant createdDate;
        private String description;
        private String instanceArn;
        private String name;
        private PortalOptions portalOptions;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationResponse model) {
            super(model);
            this.applicationAccount(model.applicationAccount);
            this.applicationArn(model.applicationArn);
            this.applicationProviderArn(model.applicationProviderArn);
            this.createdDate(model.createdDate);
            this.description(model.description);
            this.instanceArn(model.instanceArn);
            this.name(model.name);
            this.portalOptions(model.portalOptions);
            this.status(model.status);
        }

        public final String getApplicationAccount() {
            return this.applicationAccount;
        }

        public final void setApplicationAccount(String applicationAccount) {
            this.applicationAccount = applicationAccount;
        }

        @Override
        public final Builder applicationAccount(String applicationAccount) {
            this.applicationAccount = applicationAccount;
            return this;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationProviderArn() {
            return this.applicationProviderArn;
        }

        public final void setApplicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
        }

        @Override
        public final Builder applicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PortalOptions.Builder getPortalOptions() {
            return this.portalOptions != null ? this.portalOptions.toBuilder() : null;
        }

        public final void setPortalOptions(PortalOptions.BuilderImpl portalOptions) {
            this.portalOptions = portalOptions != null ? portalOptions.build() : null;
        }

        @Override
        public final Builder portalOptions(PortalOptions portalOptions) {
            this.portalOptions = portalOptions;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeApplicationResponse build() {
            return new DescribeApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationResponse> {
        public Builder applicationAccount(String var1);

        public Builder applicationArn(String var1);

        public Builder applicationProviderArn(String var1);

        public Builder createdDate(Instant var1);

        public Builder description(String var1);

        public Builder instanceArn(String var1);

        public Builder name(String var1);

        public Builder portalOptions(PortalOptions var1);

        default public Builder portalOptions(Consumer<PortalOptions.Builder> portalOptions) {
            return this.portalOptions((PortalOptions)((PortalOptions.Builder)PortalOptions.builder().applyMutation(portalOptions)).build());
        }

        public Builder status(String var1);

        public Builder status(ApplicationStatus var1);
    }
}

