/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.PrincipalType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountAssignmentForPrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountAssignmentForPrincipal> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(AccountAssignmentForPrincipal.getter(AccountAssignmentForPrincipal::accountId)).setter(AccountAssignmentForPrincipal.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionSetArn").getter(AccountAssignmentForPrincipal.getter(AccountAssignmentForPrincipal::permissionSetArn)).setter(AccountAssignmentForPrincipal.setter(Builder::permissionSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalId").getter(AccountAssignmentForPrincipal.getter(AccountAssignmentForPrincipal::principalId)).setter(AccountAssignmentForPrincipal.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()}).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrincipalType").getter(AccountAssignmentForPrincipal.getter(AccountAssignmentForPrincipal::principalTypeAsString)).setter(AccountAssignmentForPrincipal.setter(Builder::principalType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, PERMISSION_SET_ARN_FIELD, PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String permissionSetArn;
    private final String principalId;
    private final String principalType;

    private AccountAssignmentForPrincipal(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.permissionSetArn = builder.permissionSetArn;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String permissionSetArn() {
        return this.permissionSetArn;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public final String principalTypeAsString() {
        return this.principalType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAssignmentForPrincipal)) {
            return false;
        }
        AccountAssignmentForPrincipal other = (AccountAssignmentForPrincipal)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.permissionSetArn(), other.permissionSetArn()) && Objects.equals(this.principalId(), other.principalId()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AccountAssignmentForPrincipal").add("AccountId", (Object)this.accountId()).add("PermissionSetArn", (Object)this.permissionSetArn()).add("PrincipalId", (Object)this.principalId()).add("PrincipalType", (Object)this.principalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "PermissionSetArn": {
                return Optional.ofNullable(clazz.cast(this.permissionSetArn()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountAssignmentForPrincipal, T> g) {
        return obj -> g.apply((AccountAssignmentForPrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String permissionSetArn;
        private String principalId;
        private String principalType;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAssignmentForPrincipal model) {
            this.accountId(model.accountId);
            this.permissionSetArn(model.permissionSetArn);
            this.principalId(model.principalId);
            this.principalType(model.principalType);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getPermissionSetArn() {
            return this.permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public AccountAssignmentForPrincipal build() {
            return new AccountAssignmentForPrincipal(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountAssignmentForPrincipal> {
        public Builder accountId(String var1);

        public Builder permissionSetArn(String var1);

        public Builder principalId(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);
    }
}

