/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersResponse;
import software.amazon.awssdk.services.ssoadmin.model.TrustedTokenIssuerMetadata;

public class ListTrustedTokenIssuersIterable
implements SdkIterable<ListTrustedTokenIssuersResponse> {
    private final SsoAdminClient client;
    private final ListTrustedTokenIssuersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrustedTokenIssuersIterable(SsoAdminClient client, ListTrustedTokenIssuersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrustedTokenIssuersResponseFetcher();
    }

    public Iterator<ListTrustedTokenIssuersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrustedTokenIssuerMetadata> trustedTokenIssuers() {
        Function<ListTrustedTokenIssuersResponse, Iterator> getIterator = response -> {
            if (response != null && response.trustedTokenIssuers() != null) {
                return response.trustedTokenIssuers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTrustedTokenIssuersResponseFetcher
    implements SyncPageFetcher<ListTrustedTokenIssuersResponse> {
        private ListTrustedTokenIssuersResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustedTokenIssuersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrustedTokenIssuersResponse nextPage(ListTrustedTokenIssuersResponse previousPage) {
            if (previousPage == null) {
                return ListTrustedTokenIssuersIterable.this.client.listTrustedTokenIssuers(ListTrustedTokenIssuersIterable.this.firstRequest);
            }
            return ListTrustedTokenIssuersIterable.this.client.listTrustedTokenIssuers((ListTrustedTokenIssuersRequest)((Object)ListTrustedTokenIssuersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

