/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePermissionSetRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, UpdatePermissionSetRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdatePermissionSetRequest.getter(UpdatePermissionSetRequest::description)).setter(UpdatePermissionSetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceArn").getter(UpdatePermissionSetRequest.getter(UpdatePermissionSetRequest::instanceArn)).setter(UpdatePermissionSetRequest.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()}).build();
    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PermissionSetArn").getter(UpdatePermissionSetRequest.getter(UpdatePermissionSetRequest::permissionSetArn)).setter(UpdatePermissionSetRequest.setter(Builder::permissionSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()}).build();
    private static final SdkField<String> RELAY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RelayState").getter(UpdatePermissionSetRequest.getter(UpdatePermissionSetRequest::relayState)).setter(UpdatePermissionSetRequest.setter(Builder::relayState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelayState").build()}).build();
    private static final SdkField<String> SESSION_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionDuration").getter(UpdatePermissionSetRequest.getter(UpdatePermissionSetRequest::sessionDuration)).setter(UpdatePermissionSetRequest.setter(Builder::sessionDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionDuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, INSTANCE_ARN_FIELD, PERMISSION_SET_ARN_FIELD, RELAY_STATE_FIELD, SESSION_DURATION_FIELD));
    private final String description;
    private final String instanceArn;
    private final String permissionSetArn;
    private final String relayState;
    private final String sessionDuration;

    private UpdatePermissionSetRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.instanceArn = builder.instanceArn;
        this.permissionSetArn = builder.permissionSetArn;
        this.relayState = builder.relayState;
        this.sessionDuration = builder.sessionDuration;
    }

    public final String description() {
        return this.description;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String permissionSetArn() {
        return this.permissionSetArn;
    }

    public final String relayState() {
        return this.relayState;
    }

    public final String sessionDuration() {
        return this.sessionDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.relayState());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionDuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePermissionSetRequest)) {
            return false;
        }
        UpdatePermissionSetRequest other = (UpdatePermissionSetRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.permissionSetArn(), other.permissionSetArn()) && Objects.equals(this.relayState(), other.relayState()) && Objects.equals(this.sessionDuration(), other.sessionDuration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePermissionSetRequest").add("Description", (Object)this.description()).add("InstanceArn", (Object)this.instanceArn()).add("PermissionSetArn", (Object)this.permissionSetArn()).add("RelayState", (Object)this.relayState()).add("SessionDuration", (Object)this.sessionDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "PermissionSetArn": {
                return Optional.ofNullable(clazz.cast(this.permissionSetArn()));
            }
            case "RelayState": {
                return Optional.ofNullable(clazz.cast(this.relayState()));
            }
            case "SessionDuration": {
                return Optional.ofNullable(clazz.cast(this.sessionDuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePermissionSetRequest, T> g) {
        return obj -> g.apply((UpdatePermissionSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String description;
        private String instanceArn;
        private String permissionSetArn;
        private String relayState;
        private String sessionDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePermissionSetRequest model) {
            super(model);
            this.description(model.description);
            this.instanceArn(model.instanceArn);
            this.permissionSetArn(model.permissionSetArn);
            this.relayState(model.relayState);
            this.sessionDuration(model.sessionDuration);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getPermissionSetArn() {
            return this.permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getRelayState() {
            return this.relayState;
        }

        public final void setRelayState(String relayState) {
            this.relayState = relayState;
        }

        @Override
        public final Builder relayState(String relayState) {
            this.relayState = relayState;
            return this;
        }

        public final String getSessionDuration() {
            return this.sessionDuration;
        }

        public final void setSessionDuration(String sessionDuration) {
            this.sessionDuration = sessionDuration;
        }

        @Override
        public final Builder sessionDuration(String sessionDuration) {
            this.sessionDuration = sessionDuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePermissionSetRequest build() {
            return new UpdatePermissionSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePermissionSetRequest> {
        public Builder description(String var1);

        public Builder instanceArn(String var1);

        public Builder permissionSetArn(String var1);

        public Builder relayState(String var1);

        public Builder sessionDuration(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

