/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse;

public class ListPermissionSetsProvisionedToAccountIterable
implements SdkIterable<ListPermissionSetsProvisionedToAccountResponse> {
    private final SsoAdminClient client;
    private final ListPermissionSetsProvisionedToAccountRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPermissionSetsProvisionedToAccountIterable(SsoAdminClient client, ListPermissionSetsProvisionedToAccountRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPermissionSetsProvisionedToAccountResponseFetcher();
    }

    public Iterator<ListPermissionSetsProvisionedToAccountResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> permissionSets() {
        Function<ListPermissionSetsProvisionedToAccountResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissionSets() != null) {
                return response.permissionSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPermissionSetsProvisionedToAccountResponseFetcher
    implements SyncPageFetcher<ListPermissionSetsProvisionedToAccountResponse> {
        private ListPermissionSetsProvisionedToAccountResponseFetcher() {
        }

        public boolean hasNextPage(ListPermissionSetsProvisionedToAccountResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPermissionSetsProvisionedToAccountResponse nextPage(ListPermissionSetsProvisionedToAccountResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionSetsProvisionedToAccountIterable.this.client.listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountIterable.this.firstRequest);
            }
            return ListPermissionSetsProvisionedToAccountIterable.this.client.listPermissionSetsProvisionedToAccount((ListPermissionSetsProvisionedToAccountRequest)((Object)ListPermissionSetsProvisionedToAccountIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

