/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.services.ssoadmin.SsoAdminBaseClientBuilder;
import software.amazon.awssdk.services.ssoadmin.endpoints.SsoAdminEndpointProvider;
import software.amazon.awssdk.services.ssoadmin.endpoints.internal.SsoAdminEndpointAuthSchemeInterceptor;
import software.amazon.awssdk.services.ssoadmin.endpoints.internal.SsoAdminRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.ssoadmin.endpoints.internal.SsoAdminResolveEndpointInterceptor;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultSsoAdminBaseClientBuilder<B extends SsoAdminBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultSsoAdminBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "sso";
    }

    protected final String serviceName() {
        return "SsoAdmin";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkAdvancedClientOption.SIGNER, (Object)this.defaultSigner()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)false));
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new SsoAdminResolveEndpointInterceptor());
        endpointInterceptors.add(new SsoAdminEndpointAuthSchemeInterceptor());
        endpointInterceptors.add(new SsoAdminRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/ssoadmin/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        return config.toBuilder().option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    protected final String signingName() {
        return "sso";
    }

    private SsoAdminEndpointProvider defaultEndpointProvider() {
        return SsoAdminEndpointProvider.defaultProvider();
    }
}

