/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.InstanceAccessControlAttributeConfiguration;
import software.amazon.awssdk.services.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeInstanceAccessControlAttributeConfigurationResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, DescribeInstanceAccessControlAttributeConfigurationResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeInstanceAccessControlAttributeConfigurationResponse.getter(DescribeInstanceAccessControlAttributeConfigurationResponse::statusAsString)).setter(DescribeInstanceAccessControlAttributeConfigurationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(DescribeInstanceAccessControlAttributeConfigurationResponse.getter(DescribeInstanceAccessControlAttributeConfigurationResponse::statusReason)).setter(DescribeInstanceAccessControlAttributeConfigurationResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<InstanceAccessControlAttributeConfiguration> INSTANCE_ACCESS_CONTROL_ATTRIBUTE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceAccessControlAttributeConfiguration").getter(DescribeInstanceAccessControlAttributeConfigurationResponse.getter(DescribeInstanceAccessControlAttributeConfigurationResponse::instanceAccessControlAttributeConfiguration)).setter(DescribeInstanceAccessControlAttributeConfigurationResponse.setter(Builder::instanceAccessControlAttributeConfiguration)).constructor(InstanceAccessControlAttributeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceAccessControlAttributeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_REASON_FIELD, INSTANCE_ACCESS_CONTROL_ATTRIBUTE_CONFIGURATION_FIELD));
    private final String status;
    private final String statusReason;
    private final InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration;

    private DescribeInstanceAccessControlAttributeConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.instanceAccessControlAttributeConfiguration = builder.instanceAccessControlAttributeConfiguration;
    }

    public final InstanceAccessControlAttributeConfigurationStatus status() {
        return InstanceAccessControlAttributeConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration() {
        return this.instanceAccessControlAttributeConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceAccessControlAttributeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceAccessControlAttributeConfigurationResponse)) {
            return false;
        }
        DescribeInstanceAccessControlAttributeConfigurationResponse other = (DescribeInstanceAccessControlAttributeConfigurationResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.instanceAccessControlAttributeConfiguration(), other.instanceAccessControlAttributeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeInstanceAccessControlAttributeConfigurationResponse").add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("InstanceAccessControlAttributeConfiguration", (Object)this.instanceAccessControlAttributeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "InstanceAccessControlAttributeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.instanceAccessControlAttributeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceAccessControlAttributeConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeInstanceAccessControlAttributeConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private String status;
        private String statusReason;
        private InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceAccessControlAttributeConfigurationResponse model) {
            super(model);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.instanceAccessControlAttributeConfiguration(model.instanceAccessControlAttributeConfiguration);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(InstanceAccessControlAttributeConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        @Transient
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final InstanceAccessControlAttributeConfiguration.Builder getInstanceAccessControlAttributeConfiguration() {
            return this.instanceAccessControlAttributeConfiguration != null ? this.instanceAccessControlAttributeConfiguration.toBuilder() : null;
        }

        public final void setInstanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfiguration.BuilderImpl instanceAccessControlAttributeConfiguration) {
            this.instanceAccessControlAttributeConfiguration = instanceAccessControlAttributeConfiguration != null ? instanceAccessControlAttributeConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfiguration instanceAccessControlAttributeConfiguration) {
            this.instanceAccessControlAttributeConfiguration = instanceAccessControlAttributeConfiguration;
            return this;
        }

        @Override
        public DescribeInstanceAccessControlAttributeConfigurationResponse build() {
            return new DescribeInstanceAccessControlAttributeConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeInstanceAccessControlAttributeConfigurationResponse> {
        public Builder status(String var1);

        public Builder status(InstanceAccessControlAttributeConfigurationStatus var1);

        public Builder statusReason(String var1);

        public Builder instanceAccessControlAttributeConfiguration(InstanceAccessControlAttributeConfiguration var1);

        default public Builder instanceAccessControlAttributeConfiguration(Consumer<InstanceAccessControlAttributeConfiguration.Builder> instanceAccessControlAttributeConfiguration) {
            return this.instanceAccessControlAttributeConfiguration((InstanceAccessControlAttributeConfiguration)((InstanceAccessControlAttributeConfiguration.Builder)InstanceAccessControlAttributeConfiguration.builder().applyMutation(instanceAccessControlAttributeConfiguration)).build());
        }
    }
}

