/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoleCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoleCredentials> {
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessKeyId").getter(RoleCredentials.getter(RoleCredentials::accessKeyId)).setter(RoleCredentials.setter(Builder::accessKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKeyId").build()}).build();
    private static final SdkField<String> SECRET_ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secretAccessKey").getter(RoleCredentials.getter(RoleCredentials::secretAccessKey)).setter(RoleCredentials.setter(Builder::secretAccessKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretAccessKey").build()}).build();
    private static final SdkField<String> SESSION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionToken").getter(RoleCredentials.getter(RoleCredentials::sessionToken)).setter(RoleCredentials.setter(Builder::sessionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionToken").build()}).build();
    private static final SdkField<Long> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("expiration").getter(RoleCredentials.getter(RoleCredentials::expiration)).setter(RoleCredentials.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_KEY_ID_FIELD, SECRET_ACCESS_KEY_FIELD, SESSION_TOKEN_FIELD, EXPIRATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private final Long expiration;

    private RoleCredentials(BuilderImpl builder) {
        this.accessKeyId = builder.accessKeyId;
        this.secretAccessKey = builder.secretAccessKey;
        this.sessionToken = builder.sessionToken;
        this.expiration = builder.expiration;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    public Long expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretAccessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleCredentials)) {
            return false;
        }
        RoleCredentials other = (RoleCredentials)obj;
        return Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.secretAccessKey(), other.secretAccessKey()) && Objects.equals(this.sessionToken(), other.sessionToken()) && Objects.equals(this.expiration(), other.expiration());
    }

    public String toString() {
        return ToString.builder((String)"RoleCredentials").add("AccessKeyId", (Object)this.accessKeyId()).add("SecretAccessKey", (Object)(this.secretAccessKey() == null ? null : "*** Sensitive Data Redacted ***")).add("SessionToken", (Object)(this.sessionToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Expiration", (Object)this.expiration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "secretAccessKey": {
                return Optional.ofNullable(clazz.cast(this.secretAccessKey()));
            }
            case "sessionToken": {
                return Optional.ofNullable(clazz.cast(this.sessionToken()));
            }
            case "expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoleCredentials, T> g) {
        return obj -> g.apply((RoleCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessKeyId;
        private String secretAccessKey;
        private String sessionToken;
        private Long expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleCredentials model) {
            this.accessKeyId(model.accessKeyId);
            this.secretAccessKey(model.secretAccessKey);
            this.sessionToken(model.sessionToken);
            this.expiration(model.expiration);
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getSecretAccessKey() {
            return this.secretAccessKey;
        }

        @Override
        public final Builder secretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
            return this;
        }

        public final void setSecretAccessKey(String secretAccessKey) {
            this.secretAccessKey = secretAccessKey;
        }

        public final String getSessionToken() {
            return this.sessionToken;
        }

        @Override
        public final Builder sessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
            return this;
        }

        public final void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public final Long getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Long expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Long expiration) {
            this.expiration = expiration;
        }

        public RoleCredentials build() {
            return new RoleCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoleCredentials> {
        public Builder accessKeyId(String var1);

        public Builder secretAccessKey(String var1);

        public Builder sessionToken(String var1);

        public Builder expiration(Long var1);
    }
}

