/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckType;
import software.amazon.awssdk.services.ssmsap.model.OperationStatus;
import software.amazon.awssdk.services.ssmsap.model.RuleStatusCounts;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationCheckOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationCheckOperation> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::id)).setter(ConfigurationCheckOperation.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::applicationId)).setter(ConfigurationCheckOperation.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::statusAsString)).setter(ConfigurationCheckOperation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::statusMessage)).setter(ConfigurationCheckOperation.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> CONFIGURATION_CHECK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationCheckId").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::configurationCheckIdAsString)).setter(ConfigurationCheckOperation.setter(Builder::configurationCheckId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationCheckId").build()}).build();
    private static final SdkField<String> CONFIGURATION_CHECK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationCheckName").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::configurationCheckName)).setter(ConfigurationCheckOperation.setter(Builder::configurationCheckName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationCheckName").build()}).build();
    private static final SdkField<String> CONFIGURATION_CHECK_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationCheckDescription").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::configurationCheckDescription)).setter(ConfigurationCheckOperation.setter(Builder::configurationCheckDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationCheckDescription").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::startTime)).setter(ConfigurationCheckOperation.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::endTime)).setter(ConfigurationCheckOperation.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<RuleStatusCounts> RULE_STATUS_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuleStatusCounts").getter(ConfigurationCheckOperation.getter(ConfigurationCheckOperation::ruleStatusCounts)).setter(ConfigurationCheckOperation.setter(Builder::ruleStatusCounts)).constructor(RuleStatusCounts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatusCounts").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, APPLICATION_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CONFIGURATION_CHECK_ID_FIELD, CONFIGURATION_CHECK_NAME_FIELD, CONFIGURATION_CHECK_DESCRIPTION_FIELD, START_TIME_FIELD, END_TIME_FIELD, RULE_STATUS_COUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationCheckOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String applicationId;
    private final String status;
    private final String statusMessage;
    private final String configurationCheckId;
    private final String configurationCheckName;
    private final String configurationCheckDescription;
    private final Instant startTime;
    private final Instant endTime;
    private final RuleStatusCounts ruleStatusCounts;

    private ConfigurationCheckOperation(BuilderImpl builder) {
        this.id = builder.id;
        this.applicationId = builder.applicationId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.configurationCheckId = builder.configurationCheckId;
        this.configurationCheckName = builder.configurationCheckName;
        this.configurationCheckDescription = builder.configurationCheckDescription;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ruleStatusCounts = builder.ruleStatusCounts;
    }

    public final String id() {
        return this.id;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final OperationStatus status() {
        return OperationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final ConfigurationCheckType configurationCheckId() {
        return ConfigurationCheckType.fromValue(this.configurationCheckId);
    }

    public final String configurationCheckIdAsString() {
        return this.configurationCheckId;
    }

    public final String configurationCheckName() {
        return this.configurationCheckName;
    }

    public final String configurationCheckDescription() {
        return this.configurationCheckDescription;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final RuleStatusCounts ruleStatusCounts() {
        return this.ruleStatusCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationCheckIdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationCheckName());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationCheckDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleStatusCounts());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationCheckOperation)) {
            return false;
        }
        ConfigurationCheckOperation other = (ConfigurationCheckOperation)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.configurationCheckIdAsString(), other.configurationCheckIdAsString()) && Objects.equals(this.configurationCheckName(), other.configurationCheckName()) && Objects.equals(this.configurationCheckDescription(), other.configurationCheckDescription()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.ruleStatusCounts(), other.ruleStatusCounts());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationCheckOperation").add("Id", (Object)this.id()).add("ApplicationId", (Object)this.applicationId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("ConfigurationCheckId", (Object)this.configurationCheckIdAsString()).add("ConfigurationCheckName", (Object)this.configurationCheckName()).add("ConfigurationCheckDescription", (Object)this.configurationCheckDescription()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("RuleStatusCounts", (Object)this.ruleStatusCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "ConfigurationCheckId": {
                return Optional.ofNullable(clazz.cast(this.configurationCheckIdAsString()));
            }
            case "ConfigurationCheckName": {
                return Optional.ofNullable(clazz.cast(this.configurationCheckName()));
            }
            case "ConfigurationCheckDescription": {
                return Optional.ofNullable(clazz.cast(this.configurationCheckDescription()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "RuleStatusCounts": {
                return Optional.ofNullable(clazz.cast(this.ruleStatusCounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("ApplicationId", APPLICATION_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("ConfigurationCheckId", CONFIGURATION_CHECK_ID_FIELD);
        map.put("ConfigurationCheckName", CONFIGURATION_CHECK_NAME_FIELD);
        map.put("ConfigurationCheckDescription", CONFIGURATION_CHECK_DESCRIPTION_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("RuleStatusCounts", RULE_STATUS_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationCheckOperation, T> g) {
        return obj -> g.apply((ConfigurationCheckOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String applicationId;
        private String status;
        private String statusMessage;
        private String configurationCheckId;
        private String configurationCheckName;
        private String configurationCheckDescription;
        private Instant startTime;
        private Instant endTime;
        private RuleStatusCounts ruleStatusCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationCheckOperation model) {
            this.id(model.id);
            this.applicationId(model.applicationId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.configurationCheckId(model.configurationCheckId);
            this.configurationCheckName(model.configurationCheckName);
            this.configurationCheckDescription(model.configurationCheckDescription);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.ruleStatusCounts(model.ruleStatusCounts);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OperationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getConfigurationCheckId() {
            return this.configurationCheckId;
        }

        public final void setConfigurationCheckId(String configurationCheckId) {
            this.configurationCheckId = configurationCheckId;
        }

        @Override
        public final Builder configurationCheckId(String configurationCheckId) {
            this.configurationCheckId = configurationCheckId;
            return this;
        }

        @Override
        public final Builder configurationCheckId(ConfigurationCheckType configurationCheckId) {
            this.configurationCheckId(configurationCheckId == null ? null : configurationCheckId.toString());
            return this;
        }

        public final String getConfigurationCheckName() {
            return this.configurationCheckName;
        }

        public final void setConfigurationCheckName(String configurationCheckName) {
            this.configurationCheckName = configurationCheckName;
        }

        @Override
        public final Builder configurationCheckName(String configurationCheckName) {
            this.configurationCheckName = configurationCheckName;
            return this;
        }

        public final String getConfigurationCheckDescription() {
            return this.configurationCheckDescription;
        }

        public final void setConfigurationCheckDescription(String configurationCheckDescription) {
            this.configurationCheckDescription = configurationCheckDescription;
        }

        @Override
        public final Builder configurationCheckDescription(String configurationCheckDescription) {
            this.configurationCheckDescription = configurationCheckDescription;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final RuleStatusCounts.Builder getRuleStatusCounts() {
            return this.ruleStatusCounts != null ? this.ruleStatusCounts.toBuilder() : null;
        }

        public final void setRuleStatusCounts(RuleStatusCounts.BuilderImpl ruleStatusCounts) {
            this.ruleStatusCounts = ruleStatusCounts != null ? ruleStatusCounts.build() : null;
        }

        @Override
        public final Builder ruleStatusCounts(RuleStatusCounts ruleStatusCounts) {
            this.ruleStatusCounts = ruleStatusCounts;
            return this;
        }

        public ConfigurationCheckOperation build() {
            return new ConfigurationCheckOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationCheckOperation> {
        public Builder id(String var1);

        public Builder applicationId(String var1);

        public Builder status(String var1);

        public Builder status(OperationStatus var1);

        public Builder statusMessage(String var1);

        public Builder configurationCheckId(String var1);

        public Builder configurationCheckId(ConfigurationCheckType var1);

        public Builder configurationCheckName(String var1);

        public Builder configurationCheckDescription(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder ruleStatusCounts(RuleStatusCounts var1);

        default public Builder ruleStatusCounts(Consumer<RuleStatusCounts.Builder> ruleStatusCounts) {
            return this.ruleStatusCounts((RuleStatusCounts)((RuleStatusCounts.Builder)RuleStatusCounts.builder().applyMutation(ruleStatusCounts)).build());
        }
    }
}

