/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapAsyncClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckOperation;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsResponse;

public class ListConfigurationCheckOperationsPublisher
implements SdkPublisher<ListConfigurationCheckOperationsResponse> {
    private final SsmSapAsyncClient client;
    private final ListConfigurationCheckOperationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationCheckOperationsPublisher(SsmSapAsyncClient client, ListConfigurationCheckOperationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationCheckOperationsPublisher(SsmSapAsyncClient client, ListConfigurationCheckOperationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationCheckOperationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationCheckOperationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationCheckOperation> configurationCheckOperations() {
        Function<ListConfigurationCheckOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationCheckOperations() != null) {
                return response.configurationCheckOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfigurationCheckOperationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfigurationCheckOperationsResponseFetcher
    implements AsyncPageFetcher<ListConfigurationCheckOperationsResponse> {
        private ListConfigurationCheckOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationCheckOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationCheckOperationsResponse> nextPage(ListConfigurationCheckOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationCheckOperationsPublisher.this.client.listConfigurationCheckOperations(ListConfigurationCheckOperationsPublisher.this.firstRequest);
            }
            return ListConfigurationCheckOperationsPublisher.this.client.listConfigurationCheckOperations((ListConfigurationCheckOperationsRequest)((Object)ListConfigurationCheckOperationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

