/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckOperation;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsRequest;
import software.amazon.awssdk.services.ssmsap.model.ListConfigurationCheckOperationsResponse;

public class ListConfigurationCheckOperationsIterable
implements SdkIterable<ListConfigurationCheckOperationsResponse> {
    private final SsmSapClient client;
    private final ListConfigurationCheckOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConfigurationCheckOperationsIterable(SsmSapClient client, ListConfigurationCheckOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConfigurationCheckOperationsResponseFetcher();
    }

    public Iterator<ListConfigurationCheckOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConfigurationCheckOperation> configurationCheckOperations() {
        Function<ListConfigurationCheckOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationCheckOperations() != null) {
                return response.configurationCheckOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConfigurationCheckOperationsResponseFetcher
    implements SyncPageFetcher<ListConfigurationCheckOperationsResponse> {
        private ListConfigurationCheckOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationCheckOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConfigurationCheckOperationsResponse nextPage(ListConfigurationCheckOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationCheckOperationsIterable.this.client.listConfigurationCheckOperations(ListConfigurationCheckOperationsIterable.this.firstRequest);
            }
            return ListConfigurationCheckOperationsIterable.this.client.listConfigurationCheckOperations((ListConfigurationCheckOperationsRequest)((Object)ListConfigurationCheckOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

