/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.RuleResult;
import software.amazon.awssdk.services.ssmsap.model.RuleResultListCopier;
import software.amazon.awssdk.services.ssmsap.model.SsmSapResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSubCheckRuleResultsResponse
extends SsmSapResponse
implements ToCopyableBuilder<Builder, ListSubCheckRuleResultsResponse> {
    private static final SdkField<List<RuleResult>> RULE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RuleResults").getter(ListSubCheckRuleResultsResponse.getter(ListSubCheckRuleResultsResponse::ruleResults)).setter(ListSubCheckRuleResultsResponse.setter(Builder::ruleResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RuleResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSubCheckRuleResultsResponse.getter(ListSubCheckRuleResultsResponse::nextToken)).setter(ListSubCheckRuleResultsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSubCheckRuleResultsResponse.memberNameToFieldInitializer();
    private final List<RuleResult> ruleResults;
    private final String nextToken;

    private ListSubCheckRuleResultsResponse(BuilderImpl builder) {
        super(builder);
        this.ruleResults = builder.ruleResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRuleResults() {
        return this.ruleResults != null && !(this.ruleResults instanceof SdkAutoConstructList);
    }

    public final List<RuleResult> ruleResults() {
        return this.ruleResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleResults() ? this.ruleResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubCheckRuleResultsResponse)) {
            return false;
        }
        ListSubCheckRuleResultsResponse other = (ListSubCheckRuleResultsResponse)((Object)obj);
        return this.hasRuleResults() == other.hasRuleResults() && Objects.equals(this.ruleResults(), other.ruleResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSubCheckRuleResultsResponse").add("RuleResults", this.hasRuleResults() ? this.ruleResults() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleResults": {
                return Optional.ofNullable(clazz.cast(this.ruleResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleResults", RULE_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSubCheckRuleResultsResponse, T> g) {
        return obj -> g.apply((ListSubCheckRuleResultsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapResponse.BuilderImpl
    implements Builder {
        private List<RuleResult> ruleResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSubCheckRuleResultsResponse model) {
            super(model);
            this.ruleResults(model.ruleResults);
            this.nextToken(model.nextToken);
        }

        public final List<RuleResult.Builder> getRuleResults() {
            List<RuleResult.Builder> result = RuleResultListCopier.copyToBuilder(this.ruleResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRuleResults(Collection<RuleResult.BuilderImpl> ruleResults) {
            this.ruleResults = RuleResultListCopier.copyFromBuilder(ruleResults);
        }

        @Override
        public final Builder ruleResults(Collection<RuleResult> ruleResults) {
            this.ruleResults = RuleResultListCopier.copy(ruleResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(RuleResult ... ruleResults) {
            this.ruleResults(Arrays.asList(ruleResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleResults(Consumer<RuleResult.Builder> ... ruleResults) {
            this.ruleResults(Stream.of(ruleResults).map(c -> (RuleResult)((RuleResult.Builder)RuleResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSubCheckRuleResultsResponse build() {
            return new ListSubCheckRuleResultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmSapResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSubCheckRuleResultsResponse> {
        public Builder ruleResults(Collection<RuleResult> var1);

        public Builder ruleResults(RuleResult ... var1);

        public Builder ruleResults(Consumer<RuleResult.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

