/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckDefinition;
import software.amazon.awssdk.services.ssmsap.model.ConfigurationCheckDefinitionListCopier;
import software.amazon.awssdk.services.ssmsap.model.SsmSapResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationCheckDefinitionsResponse
extends SsmSapResponse
implements ToCopyableBuilder<Builder, ListConfigurationCheckDefinitionsResponse> {
    private static final SdkField<List<ConfigurationCheckDefinition>> CONFIGURATION_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationChecks").getter(ListConfigurationCheckDefinitionsResponse.getter(ListConfigurationCheckDefinitionsResponse::configurationChecks)).setter(ListConfigurationCheckDefinitionsResponse.setter(Builder::configurationChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationChecks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationCheckDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationCheckDefinitionsResponse.getter(ListConfigurationCheckDefinitionsResponse::nextToken)).setter(ListConfigurationCheckDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_CHECKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConfigurationCheckDefinitionsResponse.memberNameToFieldInitializer();
    private final List<ConfigurationCheckDefinition> configurationChecks;
    private final String nextToken;

    private ListConfigurationCheckDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.configurationChecks = builder.configurationChecks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurationChecks() {
        return this.configurationChecks != null && !(this.configurationChecks instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationCheckDefinition> configurationChecks() {
        return this.configurationChecks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationChecks() ? this.configurationChecks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationCheckDefinitionsResponse)) {
            return false;
        }
        ListConfigurationCheckDefinitionsResponse other = (ListConfigurationCheckDefinitionsResponse)((Object)obj);
        return this.hasConfigurationChecks() == other.hasConfigurationChecks() && Objects.equals(this.configurationChecks(), other.configurationChecks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationCheckDefinitionsResponse").add("ConfigurationChecks", this.hasConfigurationChecks() ? this.configurationChecks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationChecks": {
                return Optional.ofNullable(clazz.cast(this.configurationChecks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationChecks", CONFIGURATION_CHECKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationCheckDefinitionsResponse, T> g) {
        return obj -> g.apply((ListConfigurationCheckDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmSapResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationCheckDefinition> configurationChecks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationCheckDefinitionsResponse model) {
            super(model);
            this.configurationChecks(model.configurationChecks);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationCheckDefinition.Builder> getConfigurationChecks() {
            List<ConfigurationCheckDefinition.Builder> result = ConfigurationCheckDefinitionListCopier.copyToBuilder(this.configurationChecks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationChecks(Collection<ConfigurationCheckDefinition.BuilderImpl> configurationChecks) {
            this.configurationChecks = ConfigurationCheckDefinitionListCopier.copyFromBuilder(configurationChecks);
        }

        @Override
        public final Builder configurationChecks(Collection<ConfigurationCheckDefinition> configurationChecks) {
            this.configurationChecks = ConfigurationCheckDefinitionListCopier.copy(configurationChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationChecks(ConfigurationCheckDefinition ... configurationChecks) {
            this.configurationChecks(Arrays.asList(configurationChecks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationChecks(Consumer<ConfigurationCheckDefinition.Builder> ... configurationChecks) {
            this.configurationChecks(Stream.of(configurationChecks).map(c -> (ConfigurationCheckDefinition)((ConfigurationCheckDefinition.Builder)ConfigurationCheckDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationCheckDefinitionsResponse build() {
            return new ListConfigurationCheckDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmSapResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationCheckDefinitionsResponse> {
        public Builder configurationChecks(Collection<ConfigurationCheckDefinition> var1);

        public Builder configurationChecks(ConfigurationCheckDefinition ... var1);

        public Builder configurationChecks(Consumer<ConfigurationCheckDefinition.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

