/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatedHost
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociatedHost> {
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hostname").getter(AssociatedHost.getter(AssociatedHost::hostname)).setter(AssociatedHost.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2InstanceId").getter(AssociatedHost.getter(AssociatedHost::ec2InstanceId)).setter(AssociatedHost.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OsVersion").getter(AssociatedHost.getter(AssociatedHost::osVersion)).setter(AssociatedHost.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OsVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_FIELD, EC2_INSTANCE_ID_FIELD, OS_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String hostname;
    private final String ec2InstanceId;
    private final String osVersion;

    private AssociatedHost(BuilderImpl builder) {
        this.hostname = builder.hostname;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.osVersion = builder.osVersion;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public final String osVersion() {
        return this.osVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedHost)) {
            return false;
        }
        AssociatedHost other = (AssociatedHost)obj;
        return Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.osVersion(), other.osVersion());
    }

    public final String toString() {
        return ToString.builder((String)"AssociatedHost").add("Hostname", (Object)this.hostname()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("OsVersion", (Object)this.osVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "Ec2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "OsVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedHost, T> g) {
        return obj -> g.apply((AssociatedHost)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostname;
        private String ec2InstanceId;
        private String osVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedHost model) {
            this.hostname(model.hostname);
            this.ec2InstanceId(model.ec2InstanceId);
            this.osVersion(model.osVersion);
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public AssociatedHost build() {
            return new AssociatedHost(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociatedHost> {
        public Builder hostname(String var1);

        public Builder ec2InstanceId(String var1);

        public Builder osVersion(String var1);
    }
}

