/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmsap.SsmSapClient;
import software.amazon.awssdk.services.ssmsap.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmsap.model.DatabaseSummary;
import software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest;
import software.amazon.awssdk.services.ssmsap.model.ListDatabasesResponse;

public class ListDatabasesIterable
implements SdkIterable<ListDatabasesResponse> {
    private final SsmSapClient client;
    private final ListDatabasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatabasesIterable(SsmSapClient client, ListDatabasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDatabasesResponseFetcher();
    }

    public Iterator<ListDatabasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DatabaseSummary> databases() {
        Function<ListDatabasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.databases() != null) {
                return response.databases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDatabasesResponseFetcher
    implements SyncPageFetcher<ListDatabasesResponse> {
        private ListDatabasesResponseFetcher() {
        }

        public boolean hasNextPage(ListDatabasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatabasesResponse nextPage(ListDatabasesResponse previousPage) {
            if (previousPage == null) {
                return ListDatabasesIterable.this.client.listDatabases(ListDatabasesIterable.this.firstRequest);
            }
            return ListDatabasesIterable.this.client.listDatabases((ListDatabasesRequest)((Object)ListDatabasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

