/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmquicksetup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetConfigurationManagerResponse extends SsmQuickSetupResponse implements
        ToCopyableBuilder<GetConfigurationManagerResponse.Builder, GetConfigurationManagerResponse> {
    private static final SdkField<List<ConfigurationDefinition>> CONFIGURATION_DEFINITIONS_FIELD = SdkField
            .<List<ConfigurationDefinition>> builder(MarshallingType.LIST)
            .memberName("ConfigurationDefinitions")
            .getter(getter(GetConfigurationManagerResponse::configurationDefinitions))
            .setter(setter(Builder::configurationDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigurationDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigurationDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetConfigurationManagerResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetConfigurationManagerResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedAt")
            .getter(getter(GetConfigurationManagerResponse::lastModifiedAt))
            .setter(setter(Builder::lastModifiedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManagerArn").getter(getter(GetConfigurationManagerResponse::managerArn))
            .setter(setter(Builder::managerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagerArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetConfigurationManagerResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<StatusSummary>> STATUS_SUMMARIES_FIELD = SdkField
            .<List<StatusSummary>> builder(MarshallingType.LIST)
            .memberName("StatusSummaries")
            .getter(getter(GetConfigurationManagerResponse::statusSummaries))
            .setter(setter(Builder::statusSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StatusSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(StatusSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetConfigurationManagerResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CONFIGURATION_DEFINITIONS_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_MODIFIED_AT_FIELD, MANAGER_ARN_FIELD,
            NAME_FIELD, STATUS_SUMMARIES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ConfigurationDefinition> configurationDefinitions;

    private final Instant createdAt;

    private final String description;

    private final Instant lastModifiedAt;

    private final String managerArn;

    private final String name;

    private final List<StatusSummary> statusSummaries;

    private final Map<String, String> tags;

    private GetConfigurationManagerResponse(BuilderImpl builder) {
        super(builder);
        this.configurationDefinitions = builder.configurationDefinitions;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastModifiedAt = builder.lastModifiedAt;
        this.managerArn = builder.managerArn;
        this.name = builder.name;
        this.statusSummaries = builder.statusSummaries;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationDefinitions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasConfigurationDefinitions() {
        return configurationDefinitions != null && !(configurationDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration definitions association with the configuration manager.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationDefinitions} method.
     * </p>
     * 
     * @return The configuration definitions association with the configuration manager.
     */
    public final List<ConfigurationDefinition> configurationDefinitions() {
        return configurationDefinitions;
    }

    /**
     * <p>
     * The datetime stamp when the configuration manager was created.
     * </p>
     * 
     * @return The datetime stamp when the configuration manager was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The description of the configuration manager.
     * </p>
     * 
     * @return The description of the configuration manager.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The datetime stamp when the configuration manager was last updated.
     * </p>
     * 
     * @return The datetime stamp when the configuration manager was last updated.
     */
    public final Instant lastModifiedAt() {
        return lastModifiedAt;
    }

    /**
     * <p>
     * The ARN of the configuration manager.
     * </p>
     * 
     * @return The ARN of the configuration manager.
     */
    public final String managerArn() {
        return managerArn;
    }

    /**
     * <p>
     * The name of the configuration manager.
     * </p>
     * 
     * @return The name of the configuration manager.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusSummaries() {
        return statusSummaries != null && !(statusSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary of the state of the configuration manager. This includes deployment statuses, association statuses,
     * drift statuses, health checks, and more.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusSummaries} method.
     * </p>
     * 
     * @return A summary of the state of the configuration manager. This includes deployment statuses, association
     *         statuses, drift statuses, health checks, and more.
     */
    public final List<StatusSummary> statusSummaries() {
        return statusSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Key-value pairs of metadata to assign to the configuration manager.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs of metadata to assign to the configuration manager.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationDefinitions() ? configurationDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedAt());
        hashCode = 31 * hashCode + Objects.hashCode(managerArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusSummaries() ? statusSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigurationManagerResponse)) {
            return false;
        }
        GetConfigurationManagerResponse other = (GetConfigurationManagerResponse) obj;
        return hasConfigurationDefinitions() == other.hasConfigurationDefinitions()
                && Objects.equals(configurationDefinitions(), other.configurationDefinitions())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(description(), other.description())
                && Objects.equals(lastModifiedAt(), other.lastModifiedAt()) && Objects.equals(managerArn(), other.managerArn())
                && Objects.equals(name(), other.name()) && hasStatusSummaries() == other.hasStatusSummaries()
                && Objects.equals(statusSummaries(), other.statusSummaries()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetConfigurationManagerResponse")
                .add("ConfigurationDefinitions", hasConfigurationDefinitions() ? configurationDefinitions() : null)
                .add("CreatedAt", createdAt()).add("Description", description()).add("LastModifiedAt", lastModifiedAt())
                .add("ManagerArn", managerArn()).add("Name", name())
                .add("StatusSummaries", hasStatusSummaries() ? statusSummaries() : null)
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationDefinitions":
            return Optional.ofNullable(clazz.cast(configurationDefinitions()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "LastModifiedAt":
            return Optional.ofNullable(clazz.cast(lastModifiedAt()));
        case "ManagerArn":
            return Optional.ofNullable(clazz.cast(managerArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "StatusSummaries":
            return Optional.ofNullable(clazz.cast(statusSummaries()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationDefinitions", CONFIGURATION_DEFINITIONS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("LastModifiedAt", LAST_MODIFIED_AT_FIELD);
        map.put("ManagerArn", MANAGER_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("StatusSummaries", STATUS_SUMMARIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConfigurationManagerResponse, T> g) {
        return obj -> g.apply((GetConfigurationManagerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmQuickSetupResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetConfigurationManagerResponse> {
        /**
         * <p>
         * The configuration definitions association with the configuration manager.
         * </p>
         * 
         * @param configurationDefinitions
         *        The configuration definitions association with the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationDefinitions(Collection<ConfigurationDefinition> configurationDefinitions);

        /**
         * <p>
         * The configuration definitions association with the configuration manager.
         * </p>
         * 
         * @param configurationDefinitions
         *        The configuration definitions association with the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationDefinitions(ConfigurationDefinition... configurationDefinitions);

        /**
         * <p>
         * The configuration definitions association with the configuration manager.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinition.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #configurationDefinitions(List<ConfigurationDefinition>)}.
         * 
         * @param configurationDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationDefinitions(java.util.Collection<ConfigurationDefinition>)
         */
        Builder configurationDefinitions(Consumer<ConfigurationDefinition.Builder>... configurationDefinitions);

        /**
         * <p>
         * The datetime stamp when the configuration manager was created.
         * </p>
         * 
         * @param createdAt
         *        The datetime stamp when the configuration manager was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The description of the configuration manager.
         * </p>
         * 
         * @param description
         *        The description of the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The datetime stamp when the configuration manager was last updated.
         * </p>
         * 
         * @param lastModifiedAt
         *        The datetime stamp when the configuration manager was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedAt(Instant lastModifiedAt);

        /**
         * <p>
         * The ARN of the configuration manager.
         * </p>
         * 
         * @param managerArn
         *        The ARN of the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managerArn(String managerArn);

        /**
         * <p>
         * The name of the configuration manager.
         * </p>
         * 
         * @param name
         *        The name of the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A summary of the state of the configuration manager. This includes deployment statuses, association statuses,
         * drift statuses, health checks, and more.
         * </p>
         * 
         * @param statusSummaries
         *        A summary of the state of the configuration manager. This includes deployment statuses, association
         *        statuses, drift statuses, health checks, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummaries(Collection<StatusSummary> statusSummaries);

        /**
         * <p>
         * A summary of the state of the configuration manager. This includes deployment statuses, association statuses,
         * drift statuses, health checks, and more.
         * </p>
         * 
         * @param statusSummaries
         *        A summary of the state of the configuration manager. This includes deployment statuses, association
         *        statuses, drift statuses, health checks, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusSummaries(StatusSummary... statusSummaries);

        /**
         * <p>
         * A summary of the state of the configuration manager. This includes deployment statuses, association statuses,
         * drift statuses, health checks, and more.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #statusSummaries(List<StatusSummary>)}.
         * 
         * @param statusSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusSummaries(java.util.Collection<StatusSummary>)
         */
        Builder statusSummaries(Consumer<StatusSummary.Builder>... statusSummaries);

        /**
         * <p>
         * Key-value pairs of metadata to assign to the configuration manager.
         * </p>
         * 
         * @param tags
         *        Key-value pairs of metadata to assign to the configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends SsmQuickSetupResponse.BuilderImpl implements Builder {
        private List<ConfigurationDefinition> configurationDefinitions = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private String description;

        private Instant lastModifiedAt;

        private String managerArn;

        private String name;

        private List<StatusSummary> statusSummaries = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetConfigurationManagerResponse model) {
            super(model);
            configurationDefinitions(model.configurationDefinitions);
            createdAt(model.createdAt);
            description(model.description);
            lastModifiedAt(model.lastModifiedAt);
            managerArn(model.managerArn);
            name(model.name);
            statusSummaries(model.statusSummaries);
            tags(model.tags);
        }

        public final List<ConfigurationDefinition.Builder> getConfigurationDefinitions() {
            List<ConfigurationDefinition.Builder> result = ConfigurationDefinitionsListCopier
                    .copyToBuilder(this.configurationDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationDefinitions(Collection<ConfigurationDefinition.BuilderImpl> configurationDefinitions) {
            this.configurationDefinitions = ConfigurationDefinitionsListCopier.copyFromBuilder(configurationDefinitions);
        }

        @Override
        public final Builder configurationDefinitions(Collection<ConfigurationDefinition> configurationDefinitions) {
            this.configurationDefinitions = ConfigurationDefinitionsListCopier.copy(configurationDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitions(ConfigurationDefinition... configurationDefinitions) {
            configurationDefinitions(Arrays.asList(configurationDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitions(Consumer<ConfigurationDefinition.Builder>... configurationDefinitions) {
            configurationDefinitions(Stream.of(configurationDefinitions)
                    .map(c -> ConfigurationDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastModifiedAt() {
            return lastModifiedAt;
        }

        public final void setLastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
        }

        @Override
        public final Builder lastModifiedAt(Instant lastModifiedAt) {
            this.lastModifiedAt = lastModifiedAt;
            return this;
        }

        public final String getManagerArn() {
            return managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<StatusSummary.Builder> getStatusSummaries() {
            List<StatusSummary.Builder> result = StatusSummariesListCopier.copyToBuilder(this.statusSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaries(Collection<StatusSummary.BuilderImpl> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copyFromBuilder(statusSummaries);
        }

        @Override
        public final Builder statusSummaries(Collection<StatusSummary> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copy(statusSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(StatusSummary... statusSummaries) {
            statusSummaries(Arrays.asList(statusSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(Consumer<StatusSummary.Builder>... statusSummaries) {
            statusSummaries(Stream.of(statusSummaries).map(c -> StatusSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetConfigurationManagerResponse build() {
            return new GetConfigurationManagerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
