/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmquicksetup.model.QuickSetupTypeListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.QuickSetupTypeOutput;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQuickSetupTypesResponse
extends SsmQuickSetupResponse
implements ToCopyableBuilder<Builder, ListQuickSetupTypesResponse> {
    private static final SdkField<List<QuickSetupTypeOutput>> QUICK_SETUP_TYPE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QuickSetupTypeList").getter(ListQuickSetupTypesResponse.getter(ListQuickSetupTypesResponse::quickSetupTypeList)).setter(ListQuickSetupTypesResponse.setter(Builder::quickSetupTypeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickSetupTypeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QuickSetupTypeOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUICK_SETUP_TYPE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListQuickSetupTypesResponse.memberNameToFieldInitializer();
    private final List<QuickSetupTypeOutput> quickSetupTypeList;

    private ListQuickSetupTypesResponse(BuilderImpl builder) {
        super(builder);
        this.quickSetupTypeList = builder.quickSetupTypeList;
    }

    public final boolean hasQuickSetupTypeList() {
        return this.quickSetupTypeList != null && !(this.quickSetupTypeList instanceof SdkAutoConstructList);
    }

    public final List<QuickSetupTypeOutput> quickSetupTypeList() {
        return this.quickSetupTypeList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQuickSetupTypeList() ? this.quickSetupTypeList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQuickSetupTypesResponse)) {
            return false;
        }
        ListQuickSetupTypesResponse other = (ListQuickSetupTypesResponse)((Object)obj);
        return this.hasQuickSetupTypeList() == other.hasQuickSetupTypeList() && Objects.equals(this.quickSetupTypeList(), other.quickSetupTypeList());
    }

    public final String toString() {
        return ToString.builder((String)"ListQuickSetupTypesResponse").add("QuickSetupTypeList", this.hasQuickSetupTypeList() ? this.quickSetupTypeList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuickSetupTypeList": {
                return Optional.ofNullable(clazz.cast(this.quickSetupTypeList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<QuickSetupTypeOutput>>> map = new HashMap<String, SdkField<List<QuickSetupTypeOutput>>>();
        map.put("QuickSetupTypeList", QUICK_SETUP_TYPE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQuickSetupTypesResponse, T> g) {
        return obj -> g.apply((ListQuickSetupTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmQuickSetupResponse.BuilderImpl
    implements Builder {
        private List<QuickSetupTypeOutput> quickSetupTypeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListQuickSetupTypesResponse model) {
            super(model);
            this.quickSetupTypeList(model.quickSetupTypeList);
        }

        public final List<QuickSetupTypeOutput.Builder> getQuickSetupTypeList() {
            List<QuickSetupTypeOutput.Builder> result = QuickSetupTypeListCopier.copyToBuilder(this.quickSetupTypeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQuickSetupTypeList(Collection<QuickSetupTypeOutput.BuilderImpl> quickSetupTypeList) {
            this.quickSetupTypeList = QuickSetupTypeListCopier.copyFromBuilder(quickSetupTypeList);
        }

        @Override
        public final Builder quickSetupTypeList(Collection<QuickSetupTypeOutput> quickSetupTypeList) {
            this.quickSetupTypeList = QuickSetupTypeListCopier.copy(quickSetupTypeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickSetupTypeList(QuickSetupTypeOutput ... quickSetupTypeList) {
            this.quickSetupTypeList(Arrays.asList(quickSetupTypeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder quickSetupTypeList(Consumer<QuickSetupTypeOutput.Builder> ... quickSetupTypeList) {
            this.quickSetupTypeList(Stream.of(quickSetupTypeList).map(c -> (QuickSetupTypeOutput)((QuickSetupTypeOutput.Builder)QuickSetupTypeOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListQuickSetupTypesResponse build() {
            return new ListQuickSetupTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmQuickSetupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListQuickSetupTypesResponse> {
        public Builder quickSetupTypeList(Collection<QuickSetupTypeOutput> var1);

        public Builder quickSetupTypeList(QuickSetupTypeOutput ... var1);

        public Builder quickSetupTypeList(Consumer<QuickSetupTypeOutput.Builder> ... var1);
    }
}

