/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmquicksetup.model.Filter;
import software.amazon.awssdk.services.ssmquicksetup.model.FiltersListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationsRequest
extends SsmQuickSetupRequest
implements ToCopyableBuilder<Builder, ListConfigurationsRequest> {
    private static final SdkField<String> CONFIGURATION_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationDefinitionId").getter(ListConfigurationsRequest.getter(ListConfigurationsRequest::configurationDefinitionId)).setter(ListConfigurationsRequest.setter(Builder::configurationDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationDefinitionId").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(ListConfigurationsRequest.getter(ListConfigurationsRequest::filters)).setter(ListConfigurationsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagerArn").getter(ListConfigurationsRequest.getter(ListConfigurationsRequest::managerArn)).setter(ListConfigurationsRequest.setter(Builder::managerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagerArn").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListConfigurationsRequest.getter(ListConfigurationsRequest::maxItems)).setter(ListConfigurationsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final SdkField<String> STARTING_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartingToken").getter(ListConfigurationsRequest.getter(ListConfigurationsRequest::startingToken)).setter(ListConfigurationsRequest.setter(Builder::startingToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartingToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_DEFINITION_ID_FIELD, FILTERS_FIELD, MANAGER_ARN_FIELD, MAX_ITEMS_FIELD, STARTING_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConfigurationsRequest.memberNameToFieldInitializer();
    private final String configurationDefinitionId;
    private final List<Filter> filters;
    private final String managerArn;
    private final Integer maxItems;
    private final String startingToken;

    private ListConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.configurationDefinitionId = builder.configurationDefinitionId;
        this.filters = builder.filters;
        this.managerArn = builder.managerArn;
        this.maxItems = builder.maxItems;
        this.startingToken = builder.startingToken;
    }

    public final String configurationDefinitionId() {
        return this.configurationDefinitionId;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final String managerArn() {
        return this.managerArn;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String startingToken() {
        return this.startingToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationsRequest)) {
            return false;
        }
        ListConfigurationsRequest other = (ListConfigurationsRequest)((Object)obj);
        return Objects.equals(this.configurationDefinitionId(), other.configurationDefinitionId()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.managerArn(), other.managerArn()) && Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.startingToken(), other.startingToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationsRequest").add("ConfigurationDefinitionId", (Object)this.configurationDefinitionId()).add("Filters", this.hasFilters() ? this.filters() : null).add("ManagerArn", (Object)this.managerArn()).add("MaxItems", (Object)this.maxItems()).add("StartingToken", (Object)this.startingToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.configurationDefinitionId()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "ManagerArn": {
                return Optional.ofNullable(clazz.cast(this.managerArn()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "StartingToken": {
                return Optional.ofNullable(clazz.cast(this.startingToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationDefinitionId", CONFIGURATION_DEFINITION_ID_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("ManagerArn", MANAGER_ARN_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("StartingToken", STARTING_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationsRequest, T> g) {
        return obj -> g.apply((ListConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmQuickSetupRequest.BuilderImpl
    implements Builder {
        private String configurationDefinitionId;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private String managerArn;
        private Integer maxItems;
        private String startingToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationsRequest model) {
            super(model);
            this.configurationDefinitionId(model.configurationDefinitionId);
            this.filters(model.filters);
            this.managerArn(model.managerArn);
            this.maxItems(model.maxItems);
            this.startingToken(model.startingToken);
        }

        public final String getConfigurationDefinitionId() {
            return this.configurationDefinitionId;
        }

        public final void setConfigurationDefinitionId(String configurationDefinitionId) {
            this.configurationDefinitionId = configurationDefinitionId;
        }

        @Override
        public final Builder configurationDefinitionId(String configurationDefinitionId) {
            this.configurationDefinitionId = configurationDefinitionId;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FiltersListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FiltersListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FiltersListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getManagerArn() {
            return this.managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getStartingToken() {
            return this.startingToken;
        }

        public final void setStartingToken(String startingToken) {
            this.startingToken = startingToken;
        }

        @Override
        public final Builder startingToken(String startingToken) {
            this.startingToken = startingToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListConfigurationsRequest build() {
            return new ListConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmQuickSetupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationsRequest> {
        public Builder configurationDefinitionId(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder managerArn(String var1);

        public Builder maxItems(Integer var1);

        public Builder startingToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

