/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionSummariesListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationDefinitionSummary;
import software.amazon.awssdk.services.ssmquicksetup.model.StatusSummariesListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.StatusSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurationManagerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurationManagerSummary> {
    private static final SdkField<List<ConfigurationDefinitionSummary>> CONFIGURATION_DEFINITION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationDefinitionSummaries").getter(ConfigurationManagerSummary.getter(ConfigurationManagerSummary::configurationDefinitionSummaries)).setter(ConfigurationManagerSummary.setter(Builder::configurationDefinitionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationDefinitionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationDefinitionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ConfigurationManagerSummary.getter(ConfigurationManagerSummary::description)).setter(ConfigurationManagerSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> MANAGER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagerArn").getter(ConfigurationManagerSummary.getter(ConfigurationManagerSummary::managerArn)).setter(ConfigurationManagerSummary.setter(Builder::managerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagerArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ConfigurationManagerSummary.getter(ConfigurationManagerSummary::name)).setter(ConfigurationManagerSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<StatusSummary>> STATUS_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatusSummaries").getter(ConfigurationManagerSummary.getter(ConfigurationManagerSummary::statusSummaries)).setter(ConfigurationManagerSummary.setter(Builder::statusSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StatusSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_DEFINITION_SUMMARIES_FIELD, DESCRIPTION_FIELD, MANAGER_ARN_FIELD, NAME_FIELD, STATUS_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurationManagerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ConfigurationDefinitionSummary> configurationDefinitionSummaries;
    private final String description;
    private final String managerArn;
    private final String name;
    private final List<StatusSummary> statusSummaries;

    private ConfigurationManagerSummary(BuilderImpl builder) {
        this.configurationDefinitionSummaries = builder.configurationDefinitionSummaries;
        this.description = builder.description;
        this.managerArn = builder.managerArn;
        this.name = builder.name;
        this.statusSummaries = builder.statusSummaries;
    }

    public final boolean hasConfigurationDefinitionSummaries() {
        return this.configurationDefinitionSummaries != null && !(this.configurationDefinitionSummaries instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationDefinitionSummary> configurationDefinitionSummaries() {
        return this.configurationDefinitionSummaries;
    }

    public final String description() {
        return this.description;
    }

    public final String managerArn() {
        return this.managerArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasStatusSummaries() {
        return this.statusSummaries != null && !(this.statusSummaries instanceof SdkAutoConstructList);
    }

    public final List<StatusSummary> statusSummaries() {
        return this.statusSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationDefinitionSummaries() ? this.configurationDefinitionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.managerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusSummaries() ? this.statusSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationManagerSummary)) {
            return false;
        }
        ConfigurationManagerSummary other = (ConfigurationManagerSummary)obj;
        return this.hasConfigurationDefinitionSummaries() == other.hasConfigurationDefinitionSummaries() && Objects.equals(this.configurationDefinitionSummaries(), other.configurationDefinitionSummaries()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.managerArn(), other.managerArn()) && Objects.equals(this.name(), other.name()) && this.hasStatusSummaries() == other.hasStatusSummaries() && Objects.equals(this.statusSummaries(), other.statusSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurationManagerSummary").add("ConfigurationDefinitionSummaries", this.hasConfigurationDefinitionSummaries() ? this.configurationDefinitionSummaries() : null).add("Description", (Object)this.description()).add("ManagerArn", (Object)this.managerArn()).add("Name", (Object)this.name()).add("StatusSummaries", this.hasStatusSummaries() ? this.statusSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationDefinitionSummaries": {
                return Optional.ofNullable(clazz.cast(this.configurationDefinitionSummaries()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ManagerArn": {
                return Optional.ofNullable(clazz.cast(this.managerArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "StatusSummaries": {
                return Optional.ofNullable(clazz.cast(this.statusSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationDefinitionSummaries", CONFIGURATION_DEFINITION_SUMMARIES_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ManagerArn", MANAGER_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("StatusSummaries", STATUS_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurationManagerSummary, T> g) {
        return obj -> g.apply((ConfigurationManagerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ConfigurationDefinitionSummary> configurationDefinitionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String managerArn;
        private String name;
        private List<StatusSummary> statusSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurationManagerSummary model) {
            this.configurationDefinitionSummaries(model.configurationDefinitionSummaries);
            this.description(model.description);
            this.managerArn(model.managerArn);
            this.name(model.name);
            this.statusSummaries(model.statusSummaries);
        }

        public final List<ConfigurationDefinitionSummary.Builder> getConfigurationDefinitionSummaries() {
            List<ConfigurationDefinitionSummary.Builder> result = ConfigurationDefinitionSummariesListCopier.copyToBuilder(this.configurationDefinitionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationDefinitionSummaries(Collection<ConfigurationDefinitionSummary.BuilderImpl> configurationDefinitionSummaries) {
            this.configurationDefinitionSummaries = ConfigurationDefinitionSummariesListCopier.copyFromBuilder(configurationDefinitionSummaries);
        }

        @Override
        public final Builder configurationDefinitionSummaries(Collection<ConfigurationDefinitionSummary> configurationDefinitionSummaries) {
            this.configurationDefinitionSummaries = ConfigurationDefinitionSummariesListCopier.copy(configurationDefinitionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitionSummaries(ConfigurationDefinitionSummary ... configurationDefinitionSummaries) {
            this.configurationDefinitionSummaries(Arrays.asList(configurationDefinitionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationDefinitionSummaries(Consumer<ConfigurationDefinitionSummary.Builder> ... configurationDefinitionSummaries) {
            this.configurationDefinitionSummaries(Stream.of(configurationDefinitionSummaries).map(c -> (ConfigurationDefinitionSummary)((ConfigurationDefinitionSummary.Builder)ConfigurationDefinitionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getManagerArn() {
            return this.managerArn;
        }

        public final void setManagerArn(String managerArn) {
            this.managerArn = managerArn;
        }

        @Override
        public final Builder managerArn(String managerArn) {
            this.managerArn = managerArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<StatusSummary.Builder> getStatusSummaries() {
            List<StatusSummary.Builder> result = StatusSummariesListCopier.copyToBuilder(this.statusSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusSummaries(Collection<StatusSummary.BuilderImpl> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copyFromBuilder(statusSummaries);
        }

        @Override
        public final Builder statusSummaries(Collection<StatusSummary> statusSummaries) {
            this.statusSummaries = StatusSummariesListCopier.copy(statusSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(StatusSummary ... statusSummaries) {
            this.statusSummaries(Arrays.asList(statusSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusSummaries(Consumer<StatusSummary.Builder> ... statusSummaries) {
            this.statusSummaries(Stream.of(statusSummaries).map(c -> (StatusSummary)((StatusSummary.Builder)StatusSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ConfigurationManagerSummary build() {
            return new ConfigurationManagerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurationManagerSummary> {
        public Builder configurationDefinitionSummaries(Collection<ConfigurationDefinitionSummary> var1);

        public Builder configurationDefinitionSummaries(ConfigurationDefinitionSummary ... var1);

        public Builder configurationDefinitionSummaries(Consumer<ConfigurationDefinitionSummary.Builder> ... var1);

        public Builder description(String var1);

        public Builder managerArn(String var1);

        public Builder name(String var1);

        public Builder statusSummaries(Collection<StatusSummary> var1);

        public Builder statusSummaries(StatusSummary ... var1);

        public Builder statusSummaries(Consumer<StatusSummary.Builder> ... var1);
    }
}

