/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmquicksetup.SsmQuickSetupAsyncClient;
import software.amazon.awssdk.services.ssmquicksetup.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationSummary;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.ssmquicksetup.model.ListConfigurationsResponse;

public class ListConfigurationsPublisher
implements SdkPublisher<ListConfigurationsResponse> {
    private final SsmQuickSetupAsyncClient client;
    private final ListConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationsPublisher(SsmQuickSetupAsyncClient client, ListConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationsPublisher(SsmQuickSetupAsyncClient client, ListConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationSummary> configurationsList() {
        Function<ListConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationsList() != null) {
                return response.configurationsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListConfigurationsResponse> {
        private ListConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationsResponse> nextPage(ListConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationsPublisher.this.client.listConfigurations(ListConfigurationsPublisher.this.firstRequest);
            }
            return ListConfigurationsPublisher.this.client.listConfigurations((ListConfigurationsRequest)((Object)ListConfigurationsPublisher.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

