/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmquicksetup.model.Status;
import software.amazon.awssdk.services.ssmquicksetup.model.StatusDetailsCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatusSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatusSummary> {
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(StatusSummary.getter(StatusSummary::lastUpdatedAt)).setter(StatusSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StatusSummary.getter(StatusSummary::statusAsString)).setter(StatusSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StatusDetails").getter(StatusSummary.getter(StatusSummary::statusDetails)).setter(StatusSummary.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(StatusSummary.getter(StatusSummary::statusMessage)).setter(StatusSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> STATUS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusType").getter(StatusSummary.getter(StatusSummary::statusTypeAsString)).setter(StatusSummary.setter(Builder::statusType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_UPDATED_AT_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, STATUS_MESSAGE_FIELD, STATUS_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("StatusDetails", STATUS_DETAILS_FIELD);
            this.put("StatusMessage", STATUS_MESSAGE_FIELD);
            this.put("StatusType", STATUS_TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant lastUpdatedAt;
    private final String status;
    private final Map<String, String> statusDetails;
    private final String statusMessage;
    private final String statusType;

    private StatusSummary(BuilderImpl builder) {
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.statusMessage = builder.statusMessage;
        this.statusType = builder.statusType;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasStatusDetails() {
        return this.statusDetails != null && !(this.statusDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> statusDetails() {
        return this.statusDetails;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final StatusType statusType() {
        return StatusType.fromValue(this.statusType);
    }

    public final String statusTypeAsString() {
        return this.statusType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusDetails() ? this.statusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusSummary)) {
            return false;
        }
        StatusSummary other = (StatusSummary)obj;
        return Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasStatusDetails() == other.hasStatusDetails() && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.statusTypeAsString(), other.statusTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StatusSummary").add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Status", (Object)this.statusAsString()).add("StatusDetails", this.hasStatusDetails() ? this.statusDetails() : null).add("StatusMessage", (Object)this.statusMessage()).add("StatusType", (Object)this.statusTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "StatusType": {
                return Optional.ofNullable(clazz.cast(this.statusTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StatusSummary, T> g) {
        return obj -> g.apply((StatusSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastUpdatedAt;
        private String status;
        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();
        private String statusMessage;
        private String statusType;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusSummary model) {
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.statusMessage(model.statusMessage);
            this.statusType(model.statusType);
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getStatusDetails() {
            if (this.statusDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statusDetails;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = StatusDetailsCopier.copy(statusDetails);
        }

        @Override
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = StatusDetailsCopier.copy(statusDetails);
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStatusType() {
            return this.statusType;
        }

        public final void setStatusType(String statusType) {
            this.statusType = statusType;
        }

        @Override
        public final Builder statusType(String statusType) {
            this.statusType = statusType;
            return this;
        }

        @Override
        public final Builder statusType(StatusType statusType) {
            this.statusType(statusType == null ? null : statusType.toString());
            return this;
        }

        public StatusSummary build() {
            return new StatusSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatusSummary> {
        public Builder lastUpdatedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder statusDetails(Map<String, String> var1);

        public Builder statusMessage(String var1);

        public Builder statusType(String var1);

        public Builder statusType(StatusType var1);
    }
}

