/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmquicksetup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationManagerListCopier;
import software.amazon.awssdk.services.ssmquicksetup.model.ConfigurationManagerSummary;
import software.amazon.awssdk.services.ssmquicksetup.model.SsmQuickSetupResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigurationManagersResponse
extends SsmQuickSetupResponse
implements ToCopyableBuilder<Builder, ListConfigurationManagersResponse> {
    private static final SdkField<List<ConfigurationManagerSummary>> CONFIGURATION_MANAGERS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConfigurationManagersList").getter(ListConfigurationManagersResponse.getter(ListConfigurationManagersResponse::configurationManagersList)).setter(ListConfigurationManagersResponse.setter(Builder::configurationManagersList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManagersList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurationManagerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListConfigurationManagersResponse.getter(ListConfigurationManagersResponse::nextToken)).setter(ListConfigurationManagersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_MANAGERS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ConfigurationManagersList", CONFIGURATION_MANAGERS_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ConfigurationManagerSummary> configurationManagersList;
    private final String nextToken;

    private ListConfigurationManagersResponse(BuilderImpl builder) {
        super(builder);
        this.configurationManagersList = builder.configurationManagersList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasConfigurationManagersList() {
        return this.configurationManagersList != null && !(this.configurationManagersList instanceof SdkAutoConstructList);
    }

    public final List<ConfigurationManagerSummary> configurationManagersList() {
        return this.configurationManagersList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurationManagersList() ? this.configurationManagersList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationManagersResponse)) {
            return false;
        }
        ListConfigurationManagersResponse other = (ListConfigurationManagersResponse)((Object)obj);
        return this.hasConfigurationManagersList() == other.hasConfigurationManagersList() && Objects.equals(this.configurationManagersList(), other.configurationManagersList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigurationManagersResponse").add("ConfigurationManagersList", this.hasConfigurationManagersList() ? this.configurationManagersList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationManagersList": {
                return Optional.ofNullable(clazz.cast(this.configurationManagersList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListConfigurationManagersResponse, T> g) {
        return obj -> g.apply((ListConfigurationManagersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmQuickSetupResponse.BuilderImpl
    implements Builder {
        private List<ConfigurationManagerSummary> configurationManagersList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationManagersResponse model) {
            super(model);
            this.configurationManagersList(model.configurationManagersList);
            this.nextToken(model.nextToken);
        }

        public final List<ConfigurationManagerSummary.Builder> getConfigurationManagersList() {
            List<ConfigurationManagerSummary.Builder> result = ConfigurationManagerListCopier.copyToBuilder(this.configurationManagersList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurationManagersList(Collection<ConfigurationManagerSummary.BuilderImpl> configurationManagersList) {
            this.configurationManagersList = ConfigurationManagerListCopier.copyFromBuilder(configurationManagersList);
        }

        @Override
        public final Builder configurationManagersList(Collection<ConfigurationManagerSummary> configurationManagersList) {
            this.configurationManagersList = ConfigurationManagerListCopier.copy(configurationManagersList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagersList(ConfigurationManagerSummary ... configurationManagersList) {
            this.configurationManagersList(Arrays.asList(configurationManagersList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagersList(Consumer<ConfigurationManagerSummary.Builder> ... configurationManagersList) {
            this.configurationManagersList(Stream.of(configurationManagersList).map(c -> (ConfigurationManagerSummary)((ConfigurationManagerSummary.Builder)ConfigurationManagerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListConfigurationManagersResponse build() {
            return new ListConfigurationManagersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmQuickSetupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigurationManagersResponse> {
        public Builder configurationManagersList(Collection<ConfigurationManagerSummary> var1);

        public Builder configurationManagersList(ConfigurationManagerSummary ... var1);

        public Builder configurationManagersList(Consumer<ConfigurationManagerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

