/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmguiconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Bucket
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Bucket> {
    private static final SdkField<String> BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketName").getter(S3Bucket.getter(S3Bucket::bucketName)).setter(S3Bucket.setter(Builder::bucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketName").build()}).build();
    private static final SdkField<String> BUCKET_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BucketOwner").getter(S3Bucket.getter(S3Bucket::bucketOwner)).setter(S3Bucket.setter(Builder::bucketOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_NAME_FIELD, BUCKET_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3Bucket.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucketName;
    private final String bucketOwner;

    private S3Bucket(BuilderImpl builder) {
        this.bucketName = builder.bucketName;
        this.bucketOwner = builder.bucketOwner;
    }

    public final String bucketName() {
        return this.bucketName;
    }

    public final String bucketOwner() {
        return this.bucketOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Bucket)) {
            return false;
        }
        S3Bucket other = (S3Bucket)obj;
        return Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.bucketOwner(), other.bucketOwner());
    }

    public final String toString() {
        return ToString.builder((String)"S3Bucket").add("BucketName", (Object)this.bucketName()).add("BucketOwner", (Object)this.bucketOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "BucketOwner": {
                return Optional.ofNullable(clazz.cast(this.bucketOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("BucketName", BUCKET_NAME_FIELD);
        map.put("BucketOwner", BUCKET_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3Bucket, T> g) {
        return obj -> g.apply((S3Bucket)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketName;
        private String bucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Bucket model) {
            this.bucketName(model.bucketName);
            this.bucketOwner(model.bucketOwner);
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final String getBucketOwner() {
            return this.bucketOwner;
        }

        public final void setBucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
        }

        @Override
        public final Builder bucketOwner(String bucketOwner) {
            this.bucketOwner = bucketOwner;
            return this;
        }

        public S3Bucket build() {
            return new S3Bucket(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Bucket> {
        public Builder bucketName(String var1);

        public Builder bucketOwner(String var1);
    }
}

