/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about when an on-call rotation is in effect and how long the rotation period lasts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecurrenceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<RecurrenceSettings.Builder, RecurrenceSettings> {
    private static final SdkField<List<MonthlySetting>> MONTHLY_SETTINGS_FIELD = SdkField
            .<List<MonthlySetting>> builder(MarshallingType.LIST)
            .memberName("MonthlySettings")
            .getter(getter(RecurrenceSettings::monthlySettings))
            .setter(setter(Builder::monthlySettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonthlySettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonthlySetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonthlySetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<WeeklySetting>> WEEKLY_SETTINGS_FIELD = SdkField
            .<List<WeeklySetting>> builder(MarshallingType.LIST)
            .memberName("WeeklySettings")
            .getter(getter(RecurrenceSettings::weeklySettings))
            .setter(setter(Builder::weeklySettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklySettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WeeklySetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(WeeklySetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HandOffTime>> DAILY_SETTINGS_FIELD = SdkField
            .<List<HandOffTime>> builder(MarshallingType.LIST)
            .memberName("DailySettings")
            .getter(getter(RecurrenceSettings::dailySettings))
            .setter(setter(Builder::dailySettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailySettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HandOffTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(HandOffTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NUMBER_OF_ON_CALLS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfOnCalls").getter(getter(RecurrenceSettings::numberOfOnCalls))
            .setter(setter(Builder::numberOfOnCalls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfOnCalls").build()).build();

    private static final SdkField<Map<String, List<CoverageTime>>> SHIFT_COVERAGES_FIELD = SdkField
            .<Map<String, List<CoverageTime>>> builder(MarshallingType.MAP)
            .memberName("ShiftCoverages")
            .getter(getter(RecurrenceSettings::shiftCoveragesAsStrings))
            .setter(setter(Builder::shiftCoveragesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShiftCoverages").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<CoverageTime>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<CoverageTime> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(CoverageTime::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Integer> RECURRENCE_MULTIPLIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RecurrenceMultiplier").getter(getter(RecurrenceSettings::recurrenceMultiplier))
            .setter(setter(Builder::recurrenceMultiplier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecurrenceMultiplier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONTHLY_SETTINGS_FIELD,
            WEEKLY_SETTINGS_FIELD, DAILY_SETTINGS_FIELD, NUMBER_OF_ON_CALLS_FIELD, SHIFT_COVERAGES_FIELD,
            RECURRENCE_MULTIPLIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MonthlySetting> monthlySettings;

    private final List<WeeklySetting> weeklySettings;

    private final List<HandOffTime> dailySettings;

    private final Integer numberOfOnCalls;

    private final Map<String, List<CoverageTime>> shiftCoverages;

    private final Integer recurrenceMultiplier;

    private RecurrenceSettings(BuilderImpl builder) {
        this.monthlySettings = builder.monthlySettings;
        this.weeklySettings = builder.weeklySettings;
        this.dailySettings = builder.dailySettings;
        this.numberOfOnCalls = builder.numberOfOnCalls;
        this.shiftCoverages = builder.shiftCoverages;
        this.recurrenceMultiplier = builder.recurrenceMultiplier;
    }

    /**
     * For responses, this returns true if the service returned a value for the MonthlySettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMonthlySettings() {
        return monthlySettings != null && !(monthlySettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about on-call rotations that recur monthly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonthlySettings} method.
     * </p>
     * 
     * @return Information about on-call rotations that recur monthly.
     */
    public final List<MonthlySetting> monthlySettings() {
        return monthlySettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the WeeklySettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWeeklySettings() {
        return weeklySettings != null && !(weeklySettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about on-call rotations that recur weekly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWeeklySettings} method.
     * </p>
     * 
     * @return Information about on-call rotations that recur weekly.
     */
    public final List<WeeklySetting> weeklySettings() {
        return weeklySettings;
    }

    /**
     * For responses, this returns true if the service returned a value for the DailySettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDailySettings() {
        return dailySettings != null && !(dailySettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about on-call rotations that recur daily.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDailySettings} method.
     * </p>
     * 
     * @return Information about on-call rotations that recur daily.
     */
    public final List<HandOffTime> dailySettings() {
        return dailySettings;
    }

    /**
     * <p>
     * The number of contacts, or shift team members designated to be on call concurrently during a shift. For example,
     * in an on-call schedule that contains ten contacts, a value of <code>2</code> designates that two of them are on
     * call at any given time.
     * </p>
     * 
     * @return The number of contacts, or shift team members designated to be on call concurrently during a shift. For
     *         example, in an on-call schedule that contains ten contacts, a value of <code>2</code> designates that two
     *         of them are on call at any given time.
     */
    public final Integer numberOfOnCalls() {
        return numberOfOnCalls;
    }

    /**
     * <p>
     * Information about the days of the week that the on-call rotation coverage includes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShiftCoverages} method.
     * </p>
     * 
     * @return Information about the days of the week that the on-call rotation coverage includes.
     */
    public final Map<DayOfWeek, List<CoverageTime>> shiftCoverages() {
        return ShiftCoveragesMapCopier.copyStringToEnum(shiftCoverages);
    }

    /**
     * For responses, this returns true if the service returned a value for the ShiftCoverages property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasShiftCoverages() {
        return shiftCoverages != null && !(shiftCoverages instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information about the days of the week that the on-call rotation coverage includes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasShiftCoverages} method.
     * </p>
     * 
     * @return Information about the days of the week that the on-call rotation coverage includes.
     */
    public final Map<String, List<CoverageTime>> shiftCoveragesAsStrings() {
        return shiftCoverages;
    }

    /**
     * <p>
     * The number of days, weeks, or months a single rotation lasts.
     * </p>
     * 
     * @return The number of days, weeks, or months a single rotation lasts.
     */
    public final Integer recurrenceMultiplier() {
        return recurrenceMultiplier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMonthlySettings() ? monthlySettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWeeklySettings() ? weeklySettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDailySettings() ? dailySettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(numberOfOnCalls());
        hashCode = 31 * hashCode + Objects.hashCode(hasShiftCoverages() ? shiftCoveragesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recurrenceMultiplier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurrenceSettings)) {
            return false;
        }
        RecurrenceSettings other = (RecurrenceSettings) obj;
        return hasMonthlySettings() == other.hasMonthlySettings() && Objects.equals(monthlySettings(), other.monthlySettings())
                && hasWeeklySettings() == other.hasWeeklySettings() && Objects.equals(weeklySettings(), other.weeklySettings())
                && hasDailySettings() == other.hasDailySettings() && Objects.equals(dailySettings(), other.dailySettings())
                && Objects.equals(numberOfOnCalls(), other.numberOfOnCalls()) && hasShiftCoverages() == other.hasShiftCoverages()
                && Objects.equals(shiftCoveragesAsStrings(), other.shiftCoveragesAsStrings())
                && Objects.equals(recurrenceMultiplier(), other.recurrenceMultiplier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecurrenceSettings").add("MonthlySettings", hasMonthlySettings() ? monthlySettings() : null)
                .add("WeeklySettings", hasWeeklySettings() ? weeklySettings() : null)
                .add("DailySettings", hasDailySettings() ? dailySettings() : null).add("NumberOfOnCalls", numberOfOnCalls())
                .add("ShiftCoverages", hasShiftCoverages() ? shiftCoveragesAsStrings() : null)
                .add("RecurrenceMultiplier", recurrenceMultiplier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonthlySettings":
            return Optional.ofNullable(clazz.cast(monthlySettings()));
        case "WeeklySettings":
            return Optional.ofNullable(clazz.cast(weeklySettings()));
        case "DailySettings":
            return Optional.ofNullable(clazz.cast(dailySettings()));
        case "NumberOfOnCalls":
            return Optional.ofNullable(clazz.cast(numberOfOnCalls()));
        case "ShiftCoverages":
            return Optional.ofNullable(clazz.cast(shiftCoveragesAsStrings()));
        case "RecurrenceMultiplier":
            return Optional.ofNullable(clazz.cast(recurrenceMultiplier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonthlySettings", MONTHLY_SETTINGS_FIELD);
        map.put("WeeklySettings", WEEKLY_SETTINGS_FIELD);
        map.put("DailySettings", DAILY_SETTINGS_FIELD);
        map.put("NumberOfOnCalls", NUMBER_OF_ON_CALLS_FIELD);
        map.put("ShiftCoverages", SHIFT_COVERAGES_FIELD);
        map.put("RecurrenceMultiplier", RECURRENCE_MULTIPLIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecurrenceSettings, T> g) {
        return obj -> g.apply((RecurrenceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecurrenceSettings> {
        /**
         * <p>
         * Information about on-call rotations that recur monthly.
         * </p>
         * 
         * @param monthlySettings
         *        Information about on-call rotations that recur monthly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlySettings(Collection<MonthlySetting> monthlySettings);

        /**
         * <p>
         * Information about on-call rotations that recur monthly.
         * </p>
         * 
         * @param monthlySettings
         *        Information about on-call rotations that recur monthly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlySettings(MonthlySetting... monthlySettings);

        /**
         * <p>
         * Information about on-call rotations that recur monthly.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmcontacts.model.MonthlySetting.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmcontacts.model.MonthlySetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmcontacts.model.MonthlySetting.Builder#build()} is called
         * immediately and its result is passed to {@link #monthlySettings(List<MonthlySetting>)}.
         * 
         * @param monthlySettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmcontacts.model.MonthlySetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monthlySettings(java.util.Collection<MonthlySetting>)
         */
        Builder monthlySettings(Consumer<MonthlySetting.Builder>... monthlySettings);

        /**
         * <p>
         * Information about on-call rotations that recur weekly.
         * </p>
         * 
         * @param weeklySettings
         *        Information about on-call rotations that recur weekly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklySettings(Collection<WeeklySetting> weeklySettings);

        /**
         * <p>
         * Information about on-call rotations that recur weekly.
         * </p>
         * 
         * @param weeklySettings
         *        Information about on-call rotations that recur weekly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklySettings(WeeklySetting... weeklySettings);

        /**
         * <p>
         * Information about on-call rotations that recur weekly.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmcontacts.model.WeeklySetting.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmcontacts.model.WeeklySetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmcontacts.model.WeeklySetting.Builder#build()} is called immediately
         * and its result is passed to {@link #weeklySettings(List<WeeklySetting>)}.
         * 
         * @param weeklySettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmcontacts.model.WeeklySetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #weeklySettings(java.util.Collection<WeeklySetting>)
         */
        Builder weeklySettings(Consumer<WeeklySetting.Builder>... weeklySettings);

        /**
         * <p>
         * Information about on-call rotations that recur daily.
         * </p>
         * 
         * @param dailySettings
         *        Information about on-call rotations that recur daily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailySettings(Collection<HandOffTime> dailySettings);

        /**
         * <p>
         * Information about on-call rotations that recur daily.
         * </p>
         * 
         * @param dailySettings
         *        Information about on-call rotations that recur daily.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailySettings(HandOffTime... dailySettings);

        /**
         * <p>
         * Information about on-call rotations that recur daily.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmcontacts.model.HandOffTime.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmcontacts.model.HandOffTime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmcontacts.model.HandOffTime.Builder#build()} is called immediately
         * and its result is passed to {@link #dailySettings(List<HandOffTime>)}.
         * 
         * @param dailySettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmcontacts.model.HandOffTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dailySettings(java.util.Collection<HandOffTime>)
         */
        Builder dailySettings(Consumer<HandOffTime.Builder>... dailySettings);

        /**
         * <p>
         * The number of contacts, or shift team members designated to be on call concurrently during a shift. For
         * example, in an on-call schedule that contains ten contacts, a value of <code>2</code> designates that two of
         * them are on call at any given time.
         * </p>
         * 
         * @param numberOfOnCalls
         *        The number of contacts, or shift team members designated to be on call concurrently during a shift.
         *        For example, in an on-call schedule that contains ten contacts, a value of <code>2</code> designates
         *        that two of them are on call at any given time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfOnCalls(Integer numberOfOnCalls);

        /**
         * <p>
         * Information about the days of the week that the on-call rotation coverage includes.
         * </p>
         * 
         * @param shiftCoverages
         *        Information about the days of the week that the on-call rotation coverage includes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shiftCoveragesWithStrings(Map<String, ? extends Collection<CoverageTime>> shiftCoverages);

        /**
         * <p>
         * Information about the days of the week that the on-call rotation coverage includes.
         * </p>
         * 
         * @param shiftCoverages
         *        Information about the days of the week that the on-call rotation coverage includes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shiftCoverages(Map<DayOfWeek, ? extends Collection<CoverageTime>> shiftCoverages);

        /**
         * <p>
         * The number of days, weeks, or months a single rotation lasts.
         * </p>
         * 
         * @param recurrenceMultiplier
         *        The number of days, weeks, or months a single rotation lasts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrenceMultiplier(Integer recurrenceMultiplier);
    }

    static final class BuilderImpl implements Builder {
        private List<MonthlySetting> monthlySettings = DefaultSdkAutoConstructList.getInstance();

        private List<WeeklySetting> weeklySettings = DefaultSdkAutoConstructList.getInstance();

        private List<HandOffTime> dailySettings = DefaultSdkAutoConstructList.getInstance();

        private Integer numberOfOnCalls;

        private Map<String, List<CoverageTime>> shiftCoverages = DefaultSdkAutoConstructMap.getInstance();

        private Integer recurrenceMultiplier;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurrenceSettings model) {
            monthlySettings(model.monthlySettings);
            weeklySettings(model.weeklySettings);
            dailySettings(model.dailySettings);
            numberOfOnCalls(model.numberOfOnCalls);
            shiftCoveragesWithStrings(model.shiftCoverages);
            recurrenceMultiplier(model.recurrenceMultiplier);
        }

        public final List<MonthlySetting.Builder> getMonthlySettings() {
            List<MonthlySetting.Builder> result = MonthlySettingsCopier.copyToBuilder(this.monthlySettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonthlySettings(Collection<MonthlySetting.BuilderImpl> monthlySettings) {
            this.monthlySettings = MonthlySettingsCopier.copyFromBuilder(monthlySettings);
        }

        @Override
        public final Builder monthlySettings(Collection<MonthlySetting> monthlySettings) {
            this.monthlySettings = MonthlySettingsCopier.copy(monthlySettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monthlySettings(MonthlySetting... monthlySettings) {
            monthlySettings(Arrays.asList(monthlySettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monthlySettings(Consumer<MonthlySetting.Builder>... monthlySettings) {
            monthlySettings(Stream.of(monthlySettings).map(c -> MonthlySetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<WeeklySetting.Builder> getWeeklySettings() {
            List<WeeklySetting.Builder> result = WeeklySettingsCopier.copyToBuilder(this.weeklySettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWeeklySettings(Collection<WeeklySetting.BuilderImpl> weeklySettings) {
            this.weeklySettings = WeeklySettingsCopier.copyFromBuilder(weeklySettings);
        }

        @Override
        public final Builder weeklySettings(Collection<WeeklySetting> weeklySettings) {
            this.weeklySettings = WeeklySettingsCopier.copy(weeklySettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weeklySettings(WeeklySetting... weeklySettings) {
            weeklySettings(Arrays.asList(weeklySettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder weeklySettings(Consumer<WeeklySetting.Builder>... weeklySettings) {
            weeklySettings(Stream.of(weeklySettings).map(c -> WeeklySetting.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<HandOffTime.Builder> getDailySettings() {
            List<HandOffTime.Builder> result = DailySettingsCopier.copyToBuilder(this.dailySettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDailySettings(Collection<HandOffTime.BuilderImpl> dailySettings) {
            this.dailySettings = DailySettingsCopier.copyFromBuilder(dailySettings);
        }

        @Override
        public final Builder dailySettings(Collection<HandOffTime> dailySettings) {
            this.dailySettings = DailySettingsCopier.copy(dailySettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dailySettings(HandOffTime... dailySettings) {
            dailySettings(Arrays.asList(dailySettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dailySettings(Consumer<HandOffTime.Builder>... dailySettings) {
            dailySettings(Stream.of(dailySettings).map(c -> HandOffTime.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getNumberOfOnCalls() {
            return numberOfOnCalls;
        }

        public final void setNumberOfOnCalls(Integer numberOfOnCalls) {
            this.numberOfOnCalls = numberOfOnCalls;
        }

        @Override
        public final Builder numberOfOnCalls(Integer numberOfOnCalls) {
            this.numberOfOnCalls = numberOfOnCalls;
            return this;
        }

        public final Map<String, List<CoverageTime.Builder>> getShiftCoverages() {
            Map<String, List<CoverageTime.Builder>> result = ShiftCoveragesMapCopier.copyToBuilder(this.shiftCoverages);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setShiftCoverages(Map<String, ? extends Collection<CoverageTime.BuilderImpl>> shiftCoverages) {
            this.shiftCoverages = ShiftCoveragesMapCopier.copyFromBuilder(shiftCoverages);
        }

        @Override
        public final Builder shiftCoveragesWithStrings(Map<String, ? extends Collection<CoverageTime>> shiftCoverages) {
            this.shiftCoverages = ShiftCoveragesMapCopier.copy(shiftCoverages);
            return this;
        }

        @Override
        public final Builder shiftCoverages(Map<DayOfWeek, ? extends Collection<CoverageTime>> shiftCoverages) {
            this.shiftCoverages = ShiftCoveragesMapCopier.copyEnumToString(shiftCoverages);
            return this;
        }

        public final Integer getRecurrenceMultiplier() {
            return recurrenceMultiplier;
        }

        public final void setRecurrenceMultiplier(Integer recurrenceMultiplier) {
            this.recurrenceMultiplier = recurrenceMultiplier;
        }

        @Override
        public final Builder recurrenceMultiplier(Integer recurrenceMultiplier) {
            this.recurrenceMultiplier = recurrenceMultiplier;
            return this;
        }

        @Override
        public RecurrenceSettings build() {
            return new RecurrenceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
