/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRotationRequest extends SsmContactsRequest implements
        ToCopyableBuilder<CreateRotationRequest.Builder, CreateRotationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateRotationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> CONTACT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContactIds")
            .getter(getter(CreateRotationRequest::contactIds))
            .setter(setter(Builder::contactIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(CreateRotationRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZoneId").getter(getter(CreateRotationRequest::timeZoneId)).setter(setter(Builder::timeZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()).build();

    private static final SdkField<RecurrenceSettings> RECURRENCE_FIELD = SdkField
            .<RecurrenceSettings> builder(MarshallingType.SDK_POJO).memberName("Recurrence")
            .getter(getter(CreateRotationRequest::recurrence)).setter(setter(Builder::recurrence))
            .constructor(RecurrenceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateRotationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdempotencyToken").getter(getter(CreateRotationRequest::idempotencyToken))
            .setter(setter(Builder::idempotencyToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdempotencyToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONTACT_IDS_FIELD,
            START_TIME_FIELD, TIME_ZONE_ID_FIELD, RECURRENCE_FIELD, TAGS_FIELD, IDEMPOTENCY_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final List<String> contactIds;

    private final Instant startTime;

    private final String timeZoneId;

    private final RecurrenceSettings recurrence;

    private final List<Tag> tags;

    private final String idempotencyToken;

    private CreateRotationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.contactIds = builder.contactIds;
        this.startTime = builder.startTime;
        this.timeZoneId = builder.timeZoneId;
        this.recurrence = builder.recurrence;
        this.tags = builder.tags;
        this.idempotencyToken = builder.idempotencyToken;
    }

    /**
     * <p>
     * The name of the rotation.
     * </p>
     * 
     * @return The name of the rotation.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContactIds() {
        return contactIds != null && !(contactIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
     * </p>
     * <note>
     * <p>
     * Only the <code>PERSONAL</code> contact type is supported. The contact types <code>ESCALATION</code> and
     * <code>ONCALL_SCHEDULE</code> are not supported for this operation.
     * </p>
     * </note>
     * <p>
     * The order that you list the contacts in is their shift order in the rotation schedule. To change the order of the
     * contact's shifts, use the <a>UpdateRotation</a> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactIds} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the contacts to add to the rotation.</p> <note>
     *         <p>
     *         Only the <code>PERSONAL</code> contact type is supported. The contact types <code>ESCALATION</code> and
     *         <code>ONCALL_SCHEDULE</code> are not supported for this operation.
     *         </p>
     *         </note>
     *         <p>
     *         The order that you list the contacts in is their shift order in the rotation schedule. To change the
     *         order of the contact's shifts, use the <a>UpdateRotation</a> operation.
     */
    public final List<String> contactIds() {
        return contactIds;
    }

    /**
     * <p>
     * The date and time that the rotation goes into effect.
     * </p>
     * 
     * @return The date and time that the rotation goes into effect.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format. For
     * example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a
     * href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
     * </p>
     * <note>
     * <p>
     * Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard Time (PST),
     * are not supported.
     * </p>
     * </note>
     * 
     * @return The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
     *         For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a
     *         href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p> <note>
     *         <p>
     *         Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard Time
     *         (PST), are not supported.
     *         </p>
     */
    public final String timeZoneId() {
        return timeZoneId;
    }

    /**
     * <p>
     * Information about the rule that specifies when a shift's team members rotate.
     * </p>
     * 
     * @return Information about the rule that specifies when a shift's team members rotate.
     */
    public final RecurrenceSettings recurrence() {
        return recurrence;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different ways, such as
     * by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident Manager
     * resources</a> in the <i>Incident Manager User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different ways,
     *         such as by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident
     *         Manager resources</a> in the <i>Incident Manager User Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A token that ensures that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token that ensures that the operation is called only once with the specified details.
     */
    public final String idempotencyToken() {
        return idempotencyToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasContactIds() ? contactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(idempotencyToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRotationRequest)) {
            return false;
        }
        CreateRotationRequest other = (CreateRotationRequest) obj;
        return Objects.equals(name(), other.name()) && hasContactIds() == other.hasContactIds()
                && Objects.equals(contactIds(), other.contactIds()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(timeZoneId(), other.timeZoneId()) && Objects.equals(recurrence(), other.recurrence())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(idempotencyToken(), other.idempotencyToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRotationRequest").add("Name", name())
                .add("ContactIds", hasContactIds() ? contactIds() : null).add("StartTime", startTime())
                .add("TimeZoneId", timeZoneId()).add("Recurrence", recurrence()).add("Tags", hasTags() ? tags() : null)
                .add("IdempotencyToken", idempotencyToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ContactIds":
            return Optional.ofNullable(clazz.cast(contactIds()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "TimeZoneId":
            return Optional.ofNullable(clazz.cast(timeZoneId()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "IdempotencyToken":
            return Optional.ofNullable(clazz.cast(idempotencyToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ContactIds", CONTACT_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("TimeZoneId", TIME_ZONE_ID_FIELD);
        map.put("Recurrence", RECURRENCE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("IdempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRotationRequest, T> g) {
        return obj -> g.apply((CreateRotationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRotationRequest> {
        /**
         * <p>
         * The name of the rotation.
         * </p>
         * 
         * @param name
         *        The name of the rotation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
         * </p>
         * <note>
         * <p>
         * Only the <code>PERSONAL</code> contact type is supported. The contact types <code>ESCALATION</code> and
         * <code>ONCALL_SCHEDULE</code> are not supported for this operation.
         * </p>
         * </note>
         * <p>
         * The order that you list the contacts in is their shift order in the rotation schedule. To change the order of
         * the contact's shifts, use the <a>UpdateRotation</a> operation.
         * </p>
         * 
         * @param contactIds
         *        The Amazon Resource Names (ARNs) of the contacts to add to the rotation.</p> <note>
         *        <p>
         *        Only the <code>PERSONAL</code> contact type is supported. The contact types <code>ESCALATION</code>
         *        and <code>ONCALL_SCHEDULE</code> are not supported for this operation.
         *        </p>
         *        </note>
         *        <p>
         *        The order that you list the contacts in is their shift order in the rotation schedule. To change the
         *        order of the contact's shifts, use the <a>UpdateRotation</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactIds(Collection<String> contactIds);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
         * </p>
         * <note>
         * <p>
         * Only the <code>PERSONAL</code> contact type is supported. The contact types <code>ESCALATION</code> and
         * <code>ONCALL_SCHEDULE</code> are not supported for this operation.
         * </p>
         * </note>
         * <p>
         * The order that you list the contacts in is their shift order in the rotation schedule. To change the order of
         * the contact's shifts, use the <a>UpdateRotation</a> operation.
         * </p>
         * 
         * @param contactIds
         *        The Amazon Resource Names (ARNs) of the contacts to add to the rotation.</p> <note>
         *        <p>
         *        Only the <code>PERSONAL</code> contact type is supported. The contact types <code>ESCALATION</code>
         *        and <code>ONCALL_SCHEDULE</code> are not supported for this operation.
         *        </p>
         *        </note>
         *        <p>
         *        The order that you list the contacts in is their shift order in the rotation schedule. To change the
         *        order of the contact's shifts, use the <a>UpdateRotation</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactIds(String... contactIds);

        /**
         * <p>
         * The date and time that the rotation goes into effect.
         * </p>
         * 
         * @param startTime
         *        The date and time that the rotation goes into effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format. For
         * example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a
         * href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
         * </p>
         * <note>
         * <p>
         * Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard Time
         * (PST), are not supported.
         * </p>
         * </note>
         * 
         * @param timeZoneId
         *        The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format.
         *        For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a
         *        href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p> <note>
         *        <p>
         *        Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard
         *        Time (PST), are not supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZoneId(String timeZoneId);

        /**
         * <p>
         * Information about the rule that specifies when a shift's team members rotate.
         * </p>
         * 
         * @param recurrence
         *        Information about the rule that specifies when a shift's team members rotate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(RecurrenceSettings recurrence);

        /**
         * <p>
         * Information about the rule that specifies when a shift's team members rotate.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecurrenceSettings.Builder} avoiding the
         * need to create one manually via {@link RecurrenceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecurrenceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #recurrence(RecurrenceSettings)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link RecurrenceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(RecurrenceSettings)
         */
        default Builder recurrence(Consumer<RecurrenceSettings.Builder> recurrence) {
            return recurrence(RecurrenceSettings.builder().applyMutation(recurrence).build());
        }

        /**
         * <p>
         * Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different ways, such
         * as by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident Manager
         * resources</a> in the <i>Incident Manager User Guide</i>.
         * </p>
         * 
         * @param tags
         *        Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident
         *        Manager resources</a> in the <i>Incident Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different ways, such
         * as by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident Manager
         * resources</a> in the <i>Incident Manager User Guide</i>.
         * </p>
         * 
         * @param tags
         *        Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident
         *        Manager resources</a> in the <i>Incident Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different ways, such
         * as by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html">Tagging Incident Manager
         * resources</a> in the <i>Incident Manager User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmcontacts.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ssmcontacts.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmcontacts.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmcontacts.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A token that ensures that the operation is called only once with the specified details.
         * </p>
         * 
         * @param idempotencyToken
         *        A token that ensures that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idempotencyToken(String idempotencyToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String name;

        private List<String> contactIds = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private String timeZoneId;

        private RecurrenceSettings recurrence;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRotationRequest model) {
            super(model);
            name(model.name);
            contactIds(model.contactIds);
            startTime(model.startTime);
            timeZoneId(model.timeZoneId);
            recurrence(model.recurrence);
            tags(model.tags);
            idempotencyToken(model.idempotencyToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getContactIds() {
            if (contactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return contactIds;
        }

        public final void setContactIds(Collection<String> contactIds) {
            this.contactIds = RotationContactsArnListCopier.copy(contactIds);
        }

        @Override
        public final Builder contactIds(Collection<String> contactIds) {
            this.contactIds = RotationContactsArnListCopier.copy(contactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactIds(String... contactIds) {
            contactIds(Arrays.asList(contactIds));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTimeZoneId() {
            return timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final RecurrenceSettings.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        public final void setRecurrence(RecurrenceSettings.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(RecurrenceSettings recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getIdempotencyToken() {
            return idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRotationRequest build() {
            return new CreateRotationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
