/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.TimeRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEngagementsRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, ListEngagementsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListEngagementsRequest.getter(ListEngagementsRequest::nextToken)).setter(ListEngagementsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListEngagementsRequest.getter(ListEngagementsRequest::maxResults)).setter(ListEngagementsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IncidentId").getter(ListEngagementsRequest.getter(ListEngagementsRequest::incidentId)).setter(ListEngagementsRequest.setter(Builder::incidentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()}).build();
    private static final SdkField<TimeRange> TIME_RANGE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRangeValue").getter(ListEngagementsRequest.getter(ListEngagementsRequest::timeRangeValue)).setter(ListEngagementsRequest.setter(Builder::timeRangeValue)).constructor(TimeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, INCIDENT_ID_FIELD, TIME_RANGE_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEngagementsRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String incidentId;
    private final TimeRange timeRangeValue;

    private ListEngagementsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.incidentId = builder.incidentId;
        this.timeRangeValue = builder.timeRangeValue;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String incidentId() {
        return this.incidentId;
    }

    public final TimeRange timeRangeValue() {
        return this.timeRangeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementsRequest)) {
            return false;
        }
        ListEngagementsRequest other = (ListEngagementsRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.incidentId(), other.incidentId()) && Objects.equals(this.timeRangeValue(), other.timeRangeValue());
    }

    public final String toString() {
        return ToString.builder((String)"ListEngagementsRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("IncidentId", (Object)this.incidentId()).add("TimeRangeValue", (Object)this.timeRangeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "IncidentId": {
                return Optional.ofNullable(clazz.cast(this.incidentId()));
            }
            case "TimeRangeValue": {
                return Optional.ofNullable(clazz.cast(this.timeRangeValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("IncidentId", INCIDENT_ID_FIELD);
        map.put("TimeRangeValue", TIME_RANGE_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementsRequest, T> g) {
        return obj -> g.apply((ListEngagementsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String incidentId;
        private TimeRange timeRangeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementsRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.incidentId(model.incidentId);
            this.timeRangeValue(model.timeRangeValue);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getIncidentId() {
            return this.incidentId;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final TimeRange.Builder getTimeRangeValue() {
            return this.timeRangeValue != null ? this.timeRangeValue.toBuilder() : null;
        }

        public final void setTimeRangeValue(TimeRange.BuilderImpl timeRangeValue) {
            this.timeRangeValue = timeRangeValue != null ? timeRangeValue.build() : null;
        }

        @Override
        public final Builder timeRangeValue(TimeRange timeRangeValue) {
            this.timeRangeValue = timeRangeValue;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementsRequest build() {
            return new ListEngagementsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEngagementsRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder incidentId(String var1);

        public Builder timeRangeValue(TimeRange var1);

        default public Builder timeRangeValue(Consumer<TimeRange.Builder> timeRangeValue) {
            return this.timeRangeValue((TimeRange)((TimeRange.Builder)TimeRange.builder().applyMutation(timeRangeValue)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

