/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsArnListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRotationOverrideResponse
extends SsmContactsResponse
implements ToCopyableBuilder<Builder, GetRotationOverrideResponse> {
    private static final SdkField<String> ROTATION_OVERRIDE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RotationOverrideId").getter(GetRotationOverrideResponse.getter(GetRotationOverrideResponse::rotationOverrideId)).setter(GetRotationOverrideResponse.setter(Builder::rotationOverrideId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationOverrideId").build()}).build();
    private static final SdkField<String> ROTATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RotationArn").getter(GetRotationOverrideResponse.getter(GetRotationOverrideResponse::rotationArn)).setter(GetRotationOverrideResponse.setter(Builder::rotationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationArn").build()}).build();
    private static final SdkField<List<String>> NEW_CONTACT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NewContactIds").getter(GetRotationOverrideResponse.getter(GetRotationOverrideResponse::newContactIds)).setter(GetRotationOverrideResponse.setter(Builder::newContactIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewContactIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(GetRotationOverrideResponse.getter(GetRotationOverrideResponse::startTime)).setter(GetRotationOverrideResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(GetRotationOverrideResponse.getter(GetRotationOverrideResponse::endTime)).setter(GetRotationOverrideResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(GetRotationOverrideResponse.getter(GetRotationOverrideResponse::createTime)).setter(GetRotationOverrideResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_OVERRIDE_ID_FIELD, ROTATION_ARN_FIELD, NEW_CONTACT_IDS_FIELD, START_TIME_FIELD, END_TIME_FIELD, CREATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRotationOverrideResponse.memberNameToFieldInitializer();
    private final String rotationOverrideId;
    private final String rotationArn;
    private final List<String> newContactIds;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant createTime;

    private GetRotationOverrideResponse(BuilderImpl builder) {
        super(builder);
        this.rotationOverrideId = builder.rotationOverrideId;
        this.rotationArn = builder.rotationArn;
        this.newContactIds = builder.newContactIds;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.createTime = builder.createTime;
    }

    public final String rotationOverrideId() {
        return this.rotationOverrideId;
    }

    public final String rotationArn() {
        return this.rotationArn;
    }

    public final boolean hasNewContactIds() {
        return this.newContactIds != null && !(this.newContactIds instanceof SdkAutoConstructList);
    }

    public final List<String> newContactIds() {
        return this.newContactIds;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationOverrideId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNewContactIds() ? this.newContactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRotationOverrideResponse)) {
            return false;
        }
        GetRotationOverrideResponse other = (GetRotationOverrideResponse)((Object)obj);
        return Objects.equals(this.rotationOverrideId(), other.rotationOverrideId()) && Objects.equals(this.rotationArn(), other.rotationArn()) && this.hasNewContactIds() == other.hasNewContactIds() && Objects.equals(this.newContactIds(), other.newContactIds()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.createTime(), other.createTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetRotationOverrideResponse").add("RotationOverrideId", (Object)this.rotationOverrideId()).add("RotationArn", (Object)this.rotationArn()).add("NewContactIds", this.hasNewContactIds() ? this.newContactIds() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("CreateTime", (Object)this.createTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RotationOverrideId": {
                return Optional.ofNullable(clazz.cast(this.rotationOverrideId()));
            }
            case "RotationArn": {
                return Optional.ofNullable(clazz.cast(this.rotationArn()));
            }
            case "NewContactIds": {
                return Optional.ofNullable(clazz.cast(this.newContactIds()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RotationOverrideId", ROTATION_OVERRIDE_ID_FIELD);
        map.put("RotationArn", ROTATION_ARN_FIELD);
        map.put("NewContactIds", NEW_CONTACT_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRotationOverrideResponse, T> g) {
        return obj -> g.apply((GetRotationOverrideResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsResponse.BuilderImpl
    implements Builder {
        private String rotationOverrideId;
        private String rotationArn;
        private List<String> newContactIds = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private Instant createTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRotationOverrideResponse model) {
            super(model);
            this.rotationOverrideId(model.rotationOverrideId);
            this.rotationArn(model.rotationArn);
            this.newContactIds(model.newContactIds);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.createTime(model.createTime);
        }

        public final String getRotationOverrideId() {
            return this.rotationOverrideId;
        }

        public final void setRotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
        }

        @Override
        public final Builder rotationOverrideId(String rotationOverrideId) {
            this.rotationOverrideId = rotationOverrideId;
            return this;
        }

        public final String getRotationArn() {
            return this.rotationArn;
        }

        public final void setRotationArn(String rotationArn) {
            this.rotationArn = rotationArn;
        }

        @Override
        public final Builder rotationArn(String rotationArn) {
            this.rotationArn = rotationArn;
            return this;
        }

        public final Collection<String> getNewContactIds() {
            if (this.newContactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.newContactIds;
        }

        public final void setNewContactIds(Collection<String> newContactIds) {
            this.newContactIds = SsmContactsArnListCopier.copy(newContactIds);
        }

        @Override
        public final Builder newContactIds(Collection<String> newContactIds) {
            this.newContactIds = SsmContactsArnListCopier.copy(newContactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder newContactIds(String ... newContactIds) {
            this.newContactIds(Arrays.asList(newContactIds));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        public GetRotationOverrideResponse build() {
            return new GetRotationOverrideResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsmContactsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRotationOverrideResponse> {
        public Builder rotationOverrideId(String var1);

        public Builder rotationArn(String var1);

        public Builder newContactIds(Collection<String> var1);

        public Builder newContactIds(String ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder createTime(Instant var1);
    }
}

