/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssmcontacts.model.ContactType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolutionContact
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResolutionContact> {
    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactArn").getter(ResolutionContact.getter(ResolutionContact::contactArn)).setter(ResolutionContact.setter(Builder::contactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ResolutionContact.getter(ResolutionContact::typeAsString)).setter(ResolutionContact.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> STAGE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StageIndex").getter(ResolutionContact.getter(ResolutionContact::stageIndex)).setter(ResolutionContact.setter(Builder::stageIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageIndex").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ARN_FIELD, TYPE_FIELD, STAGE_INDEX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResolutionContact.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String contactArn;
    private final String type;
    private final Integer stageIndex;

    private ResolutionContact(BuilderImpl builder) {
        this.contactArn = builder.contactArn;
        this.type = builder.type;
        this.stageIndex = builder.stageIndex;
    }

    public final String contactArn() {
        return this.contactArn;
    }

    public final ContactType type() {
        return ContactType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer stageIndex() {
        return this.stageIndex;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageIndex());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolutionContact)) {
            return false;
        }
        ResolutionContact other = (ResolutionContact)obj;
        return Objects.equals(this.contactArn(), other.contactArn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stageIndex(), other.stageIndex());
    }

    public final String toString() {
        return ToString.builder((String)"ResolutionContact").add("ContactArn", (Object)this.contactArn()).add("Type", (Object)this.typeAsString()).add("StageIndex", (Object)this.stageIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactArn": {
                return Optional.ofNullable(clazz.cast(this.contactArn()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "StageIndex": {
                return Optional.ofNullable(clazz.cast(this.stageIndex()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContactArn", CONTACT_ARN_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("StageIndex", STAGE_INDEX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolutionContact, T> g) {
        return obj -> g.apply((ResolutionContact)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactArn;
        private String type;
        private Integer stageIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(ResolutionContact model) {
            this.contactArn(model.contactArn);
            this.type(model.type);
            this.stageIndex(model.stageIndex);
        }

        public final String getContactArn() {
            return this.contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ContactType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getStageIndex() {
            return this.stageIndex;
        }

        public final void setStageIndex(Integer stageIndex) {
            this.stageIndex = stageIndex;
        }

        @Override
        public final Builder stageIndex(Integer stageIndex) {
            this.stageIndex = stageIndex;
            return this;
        }

        public ResolutionContact build() {
            return new ResolutionContact(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResolutionContact> {
        public Builder contactArn(String var1);

        public Builder type(String var1);

        public Builder type(ContactType var1);

        public Builder stageIndex(Integer var1);
    }
}

