/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.ShiftDetails;
import software.amazon.awssdk.services.ssmcontacts.model.ShiftType;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RotationShift
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RotationShift> {
    private static final SdkField<List<String>> CONTACT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactIds").getter(RotationShift.getter(RotationShift::contactIds)).setter(RotationShift.setter(Builder::contactIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(RotationShift.getter(RotationShift::startTime)).setter(RotationShift.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(RotationShift.getter(RotationShift::endTime)).setter(RotationShift.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(RotationShift.getter(RotationShift::typeAsString)).setter(RotationShift.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<ShiftDetails> SHIFT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShiftDetails").getter(RotationShift.getter(RotationShift::shiftDetails)).setter(RotationShift.setter(Builder::shiftDetails)).constructor(ShiftDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShiftDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_IDS_FIELD, START_TIME_FIELD, END_TIME_FIELD, TYPE_FIELD, SHIFT_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RotationShift.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> contactIds;
    private final Instant startTime;
    private final Instant endTime;
    private final String type;
    private final ShiftDetails shiftDetails;

    private RotationShift(BuilderImpl builder) {
        this.contactIds = builder.contactIds;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.type = builder.type;
        this.shiftDetails = builder.shiftDetails;
    }

    public final boolean hasContactIds() {
        return this.contactIds != null && !(this.contactIds instanceof SdkAutoConstructList);
    }

    public final List<String> contactIds() {
        return this.contactIds;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ShiftType type() {
        return ShiftType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final ShiftDetails shiftDetails() {
        return this.shiftDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactIds() ? this.contactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.shiftDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RotationShift)) {
            return false;
        }
        RotationShift other = (RotationShift)obj;
        return this.hasContactIds() == other.hasContactIds() && Objects.equals(this.contactIds(), other.contactIds()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.shiftDetails(), other.shiftDetails());
    }

    public final String toString() {
        return ToString.builder((String)"RotationShift").add("ContactIds", this.hasContactIds() ? this.contactIds() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Type", (Object)this.typeAsString()).add("ShiftDetails", (Object)this.shiftDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactIds": {
                return Optional.ofNullable(clazz.cast(this.contactIds()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ShiftDetails": {
                return Optional.ofNullable(clazz.cast(this.shiftDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ContactIds", CONTACT_IDS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ShiftDetails", SHIFT_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RotationShift, T> g) {
        return obj -> g.apply((RotationShift)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> contactIds = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;
        private String type;
        private ShiftDetails shiftDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(RotationShift model) {
            this.contactIds(model.contactIds);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.type(model.type);
            this.shiftDetails(model.shiftDetails);
        }

        public final Collection<String> getContactIds() {
            if (this.contactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contactIds;
        }

        public final void setContactIds(Collection<String> contactIds) {
            this.contactIds = SsmContactsArnListCopier.copy(contactIds);
        }

        @Override
        public final Builder contactIds(Collection<String> contactIds) {
            this.contactIds = SsmContactsArnListCopier.copy(contactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactIds(String ... contactIds) {
            this.contactIds(Arrays.asList(contactIds));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ShiftType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ShiftDetails.Builder getShiftDetails() {
            return this.shiftDetails != null ? this.shiftDetails.toBuilder() : null;
        }

        public final void setShiftDetails(ShiftDetails.BuilderImpl shiftDetails) {
            this.shiftDetails = shiftDetails != null ? shiftDetails.build() : null;
        }

        @Override
        public final Builder shiftDetails(ShiftDetails shiftDetails) {
            this.shiftDetails = shiftDetails;
            return this;
        }

        public RotationShift build() {
            return new RotationShift(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RotationShift> {
        public Builder contactIds(Collection<String> var1);

        public Builder contactIds(String ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder type(String var1);

        public Builder type(ShiftType var1);

        public Builder shiftDetails(ShiftDetails var1);

        default public Builder shiftDetails(Consumer<ShiftDetails.Builder> shiftDetails) {
            return this.shiftDetails((ShiftDetails)((ShiftDetails.Builder)ShiftDetails.builder().applyMutation(shiftDetails)).build());
        }
    }
}

