/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.Contact;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse;

public class ListContactsPublisher
implements SdkPublisher<ListContactsResponse> {
    private final SsmContactsAsyncClient client;
    private final ListContactsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactsPublisher(SsmContactsAsyncClient client, ListContactsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactsPublisher(SsmContactsAsyncClient client, ListContactsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Contact> contacts() {
        Function<ListContactsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contacts() != null) {
                return response.contacts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContactsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContactsResponseFetcher
    implements AsyncPageFetcher<ListContactsResponse> {
        private ListContactsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactsResponse> nextPage(ListContactsResponse previousPage) {
            if (previousPage == null) {
                return ListContactsPublisher.this.client.listContacts(ListContactsPublisher.this.firstRequest);
            }
            return ListContactsPublisher.this.client.listContacts((ListContactsRequest)((Object)ListContactsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

