/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.OverrideListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.PreviewOverride;
import software.amazon.awssdk.services.ssmcontacts.model.RecurrenceSettings;
import software.amazon.awssdk.services.ssmcontacts.model.RotationPreviewMemberListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPreviewRotationShiftsRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, ListPreviewRotationShiftsRequest> {
    private static final SdkField<Instant> ROTATION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("RotationStartTime").getter(ListPreviewRotationShiftsRequest.getter(ListPreviewRotationShiftsRequest::rotationStartTime)).setter(ListPreviewRotationShiftsRequest.setter(Builder::rotationStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationStartTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ListPreviewRotationShiftsRequest.getter(ListPreviewRotationShiftsRequest::startTime)).setter(ListPreviewRotationShiftsRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ListPreviewRotationShiftsRequest.getter(ListPreviewRotationShiftsRequest::endTime)).setter(ListPreviewRotationShiftsRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<List<String>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Members").getter(ListPreviewRotationShiftsRequest.getter(ListPreviewRotationShiftsRequest::members)).setter(ListPreviewRotationShiftsRequest.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZoneId").getter(ListPreviewRotationShiftsRequest.getter(ListPreviewRotationShiftsRequest::timeZoneId)).setter(ListPreviewRotationShiftsRequest.setter(Builder::timeZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()}).build();
    private static final SdkField<RecurrenceSettings> RECURRENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recurrence").getter(ListPreviewRotationShiftsRequest.getter(ListPreviewRotationShiftsRequest::recurrence)).setter(ListPreviewRotationShiftsRequest.setter(Builder::recurrence)).constructor(RecurrenceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()}).build();
    private static final SdkField<List<PreviewOverride>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Overrides").getter(ListPreviewRotationShiftsRequest.getter(ListPreviewRotationShiftsRequest::overrides)).setter(ListPreviewRotationShiftsRequest.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PreviewOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPreviewRotationShiftsRequest.getter(ListPreviewRotationShiftsRequest::nextToken)).setter(ListPreviewRotationShiftsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListPreviewRotationShiftsRequest.getter(ListPreviewRotationShiftsRequest::maxResults)).setter(ListPreviewRotationShiftsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_START_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, MEMBERS_FIELD, TIME_ZONE_ID_FIELD, RECURRENCE_FIELD, OVERRIDES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPreviewRotationShiftsRequest.memberNameToFieldInitializer();
    private final Instant rotationStartTime;
    private final Instant startTime;
    private final Instant endTime;
    private final List<String> members;
    private final String timeZoneId;
    private final RecurrenceSettings recurrence;
    private final List<PreviewOverride> overrides;
    private final String nextToken;
    private final Integer maxResults;

    private ListPreviewRotationShiftsRequest(BuilderImpl builder) {
        super(builder);
        this.rotationStartTime = builder.rotationStartTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.members = builder.members;
        this.timeZoneId = builder.timeZoneId;
        this.recurrence = builder.recurrence;
        this.overrides = builder.overrides;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final Instant rotationStartTime() {
        return this.rotationStartTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<String> members() {
        return this.members;
    }

    public final String timeZoneId() {
        return this.timeZoneId;
    }

    public final RecurrenceSettings recurrence() {
        return this.recurrence;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructList);
    }

    public final List<PreviewOverride> overrides() {
        return this.overrides;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPreviewRotationShiftsRequest)) {
            return false;
        }
        ListPreviewRotationShiftsRequest other = (ListPreviewRotationShiftsRequest)((Object)obj);
        return Objects.equals(this.rotationStartTime(), other.rotationStartTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.recurrence(), other.recurrence()) && this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListPreviewRotationShiftsRequest").add("RotationStartTime", (Object)this.rotationStartTime()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Members", this.hasMembers() ? this.members() : null).add("TimeZoneId", (Object)this.timeZoneId()).add("Recurrence", (Object)this.recurrence()).add("Overrides", this.hasOverrides() ? this.overrides() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RotationStartTime": {
                return Optional.ofNullable(clazz.cast(this.rotationStartTime()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "TimeZoneId": {
                return Optional.ofNullable(clazz.cast(this.timeZoneId()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RotationStartTime", ROTATION_START_TIME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Members", MEMBERS_FIELD);
        map.put("TimeZoneId", TIME_ZONE_ID_FIELD);
        map.put("Recurrence", RECURRENCE_FIELD);
        map.put("Overrides", OVERRIDES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPreviewRotationShiftsRequest, T> g) {
        return obj -> g.apply((ListPreviewRotationShiftsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private Instant rotationStartTime;
        private Instant startTime;
        private Instant endTime;
        private List<String> members = DefaultSdkAutoConstructList.getInstance();
        private String timeZoneId;
        private RecurrenceSettings recurrence;
        private List<PreviewOverride> overrides = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPreviewRotationShiftsRequest model) {
            super(model);
            this.rotationStartTime(model.rotationStartTime);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.members(model.members);
            this.timeZoneId(model.timeZoneId);
            this.recurrence(model.recurrence);
            this.overrides(model.overrides);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Instant getRotationStartTime() {
            return this.rotationStartTime;
        }

        public final void setRotationStartTime(Instant rotationStartTime) {
            this.rotationStartTime = rotationStartTime;
        }

        @Override
        public final Builder rotationStartTime(Instant rotationStartTime) {
            this.rotationStartTime = rotationStartTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Collection<String> getMembers() {
            if (this.members instanceof SdkAutoConstructList) {
                return null;
            }
            return this.members;
        }

        public final void setMembers(Collection<String> members) {
            this.members = RotationPreviewMemberListCopier.copy(members);
        }

        @Override
        public final Builder members(Collection<String> members) {
            this.members = RotationPreviewMemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(String ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final RecurrenceSettings.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        public final void setRecurrence(RecurrenceSettings.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(RecurrenceSettings recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final List<PreviewOverride.Builder> getOverrides() {
            List<PreviewOverride.Builder> result = OverrideListCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOverrides(Collection<PreviewOverride.BuilderImpl> overrides) {
            this.overrides = OverrideListCopier.copyFromBuilder(overrides);
        }

        @Override
        public final Builder overrides(Collection<PreviewOverride> overrides) {
            this.overrides = OverrideListCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(PreviewOverride ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<PreviewOverride.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (PreviewOverride)((PreviewOverride.Builder)PreviewOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPreviewRotationShiftsRequest build() {
            return new ListPreviewRotationShiftsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPreviewRotationShiftsRequest> {
        public Builder rotationStartTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder members(Collection<String> var1);

        public Builder members(String ... var1);

        public Builder timeZoneId(String var1);

        public Builder recurrence(RecurrenceSettings var1);

        default public Builder recurrence(Consumer<RecurrenceSettings.Builder> recurrence) {
            return this.recurrence((RecurrenceSettings)((RecurrenceSettings.Builder)RecurrenceSettings.builder().applyMutation(recurrence)).build());
        }

        public Builder overrides(Collection<PreviewOverride> var1);

        public Builder overrides(PreviewOverride ... var1);

        public Builder overrides(Consumer<PreviewOverride.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

