/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Incident Manager reaching out to a contact or escalation plan to engage contact during an incident.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Engagement implements SdkPojo, Serializable, ToCopyableBuilder<Engagement.Builder, Engagement> {
    private static final SdkField<String> ENGAGEMENT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementArn").getter(getter(Engagement::engagementArn)).setter(setter(Builder::engagementArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementArn").build()).build();

    private static final SdkField<String> CONTACT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactArn").getter(getter(Engagement::contactArn)).setter(setter(Builder::contactArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactArn").build()).build();

    private static final SdkField<String> SENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sender")
            .getter(getter(Engagement::sender)).setter(setter(Builder::sender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sender").build()).build();

    private static final SdkField<String> INCIDENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IncidentId").getter(getter(Engagement::incidentId)).setter(setter(Builder::incidentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncidentId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(Engagement::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> STOP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StopTime").getter(getter(Engagement::stopTime)).setter(setter(Builder::stopTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StopTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGAGEMENT_ARN_FIELD,
            CONTACT_ARN_FIELD, SENDER_FIELD, INCIDENT_ID_FIELD, START_TIME_FIELD, STOP_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engagementArn;

    private final String contactArn;

    private final String sender;

    private final String incidentId;

    private final Instant startTime;

    private final Instant stopTime;

    private Engagement(BuilderImpl builder) {
        this.engagementArn = builder.engagementArn;
        this.contactArn = builder.contactArn;
        this.sender = builder.sender;
        this.incidentId = builder.incidentId;
        this.startTime = builder.startTime;
        this.stopTime = builder.stopTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the engagement.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the engagement.
     */
    public final String engagementArn() {
        return engagementArn;
    }

    /**
     * <p>
     * The ARN of the escalation plan or contact that Incident Manager is engaging.
     * </p>
     * 
     * @return The ARN of the escalation plan or contact that Incident Manager is engaging.
     */
    public final String contactArn() {
        return contactArn;
    }

    /**
     * <p>
     * The user that started the engagement.
     * </p>
     * 
     * @return The user that started the engagement.
     */
    public final String sender() {
        return sender;
    }

    /**
     * <p>
     * The ARN of the incident that's engaging the contact.
     * </p>
     * 
     * @return The ARN of the incident that's engaging the contact.
     */
    public final String incidentId() {
        return incidentId;
    }

    /**
     * <p>
     * The time that the engagement began.
     * </p>
     * 
     * @return The time that the engagement began.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time that the engagement ended.
     * </p>
     * 
     * @return The time that the engagement ended.
     */
    public final Instant stopTime() {
        return stopTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engagementArn());
        hashCode = 31 * hashCode + Objects.hashCode(contactArn());
        hashCode = 31 * hashCode + Objects.hashCode(sender());
        hashCode = 31 * hashCode + Objects.hashCode(incidentId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stopTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Engagement)) {
            return false;
        }
        Engagement other = (Engagement) obj;
        return Objects.equals(engagementArn(), other.engagementArn()) && Objects.equals(contactArn(), other.contactArn())
                && Objects.equals(sender(), other.sender()) && Objects.equals(incidentId(), other.incidentId())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stopTime(), other.stopTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Engagement").add("EngagementArn", engagementArn()).add("ContactArn", contactArn())
                .add("Sender", sender()).add("IncidentId", incidentId()).add("StartTime", startTime())
                .add("StopTime", stopTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngagementArn":
            return Optional.ofNullable(clazz.cast(engagementArn()));
        case "ContactArn":
            return Optional.ofNullable(clazz.cast(contactArn()));
        case "Sender":
            return Optional.ofNullable(clazz.cast(sender()));
        case "IncidentId":
            return Optional.ofNullable(clazz.cast(incidentId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "StopTime":
            return Optional.ofNullable(clazz.cast(stopTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Engagement, T> g) {
        return obj -> g.apply((Engagement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Engagement> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the engagement.
         * </p>
         * 
         * @param engagementArn
         *        The Amazon Resource Name (ARN) of the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementArn(String engagementArn);

        /**
         * <p>
         * The ARN of the escalation plan or contact that Incident Manager is engaging.
         * </p>
         * 
         * @param contactArn
         *        The ARN of the escalation plan or contact that Incident Manager is engaging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactArn(String contactArn);

        /**
         * <p>
         * The user that started the engagement.
         * </p>
         * 
         * @param sender
         *        The user that started the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sender(String sender);

        /**
         * <p>
         * The ARN of the incident that's engaging the contact.
         * </p>
         * 
         * @param incidentId
         *        The ARN of the incident that's engaging the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentId(String incidentId);

        /**
         * <p>
         * The time that the engagement began.
         * </p>
         * 
         * @param startTime
         *        The time that the engagement began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time that the engagement ended.
         * </p>
         * 
         * @param stopTime
         *        The time that the engagement ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopTime(Instant stopTime);
    }

    static final class BuilderImpl implements Builder {
        private String engagementArn;

        private String contactArn;

        private String sender;

        private String incidentId;

        private Instant startTime;

        private Instant stopTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Engagement model) {
            engagementArn(model.engagementArn);
            contactArn(model.contactArn);
            sender(model.sender);
            incidentId(model.incidentId);
            startTime(model.startTime);
            stopTime(model.stopTime);
        }

        public final String getEngagementArn() {
            return engagementArn;
        }

        public final void setEngagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
        }

        @Override
        public final Builder engagementArn(String engagementArn) {
            this.engagementArn = engagementArn;
            return this;
        }

        public final String getContactArn() {
            return contactArn;
        }

        public final void setContactArn(String contactArn) {
            this.contactArn = contactArn;
        }

        @Override
        public final Builder contactArn(String contactArn) {
            this.contactArn = contactArn;
            return this;
        }

        public final String getSender() {
            return sender;
        }

        public final void setSender(String sender) {
            this.sender = sender;
        }

        @Override
        public final Builder sender(String sender) {
            this.sender = sender;
            return this;
        }

        public final String getIncidentId() {
            return incidentId;
        }

        public final void setIncidentId(String incidentId) {
            this.incidentId = incidentId;
        }

        @Override
        public final Builder incidentId(String incidentId) {
            this.incidentId = incidentId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getStopTime() {
            return stopTime;
        }

        public final void setStopTime(Instant stopTime) {
            this.stopTime = stopTime;
        }

        @Override
        public final Builder stopTime(Instant stopTime) {
            this.stopTime = stopTime;
            return this;
        }

        @Override
        public Engagement build() {
            return new Engagement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
