/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.model.ListPreviewRotationShiftsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPreviewRotationShiftsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.RotationShift;

public class ListPreviewRotationShiftsIterable
implements SdkIterable<ListPreviewRotationShiftsResponse> {
    private final SsmContactsClient client;
    private final ListPreviewRotationShiftsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPreviewRotationShiftsIterable(SsmContactsClient client, ListPreviewRotationShiftsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPreviewRotationShiftsResponseFetcher();
    }

    public Iterator<ListPreviewRotationShiftsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RotationShift> rotationShifts() {
        Function<ListPreviewRotationShiftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rotationShifts() != null) {
                return response.rotationShifts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPreviewRotationShiftsResponseFetcher
    implements SyncPageFetcher<ListPreviewRotationShiftsResponse> {
        private ListPreviewRotationShiftsResponseFetcher() {
        }

        public boolean hasNextPage(ListPreviewRotationShiftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPreviewRotationShiftsResponse nextPage(ListPreviewRotationShiftsResponse previousPage) {
            if (previousPage == null) {
                return ListPreviewRotationShiftsIterable.this.client.listPreviewRotationShifts(ListPreviewRotationShiftsIterable.this.firstRequest);
            }
            return ListPreviewRotationShiftsIterable.this.client.listPreviewRotationShifts((ListPreviewRotationShiftsRequest)((Object)ListPreviewRotationShiftsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

