/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageResolutionsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListPageResolutionsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.ResolutionContact;

public class ListPageResolutionsIterable
implements SdkIterable<ListPageResolutionsResponse> {
    private final SsmContactsClient client;
    private final ListPageResolutionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPageResolutionsIterable(SsmContactsClient client, ListPageResolutionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPageResolutionsResponseFetcher();
    }

    public Iterator<ListPageResolutionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResolutionContact> pageResolutions() {
        Function<ListPageResolutionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pageResolutions() != null) {
                return response.pageResolutions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPageResolutionsResponseFetcher
    implements SyncPageFetcher<ListPageResolutionsResponse> {
        private ListPageResolutionsResponseFetcher() {
        }

        public boolean hasNextPage(ListPageResolutionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPageResolutionsResponse nextPage(ListPageResolutionsResponse previousPage) {
            if (previousPage == null) {
                return ListPageResolutionsIterable.this.client.listPageResolutions(ListPageResolutionsIterable.this.firstRequest);
            }
            return ListPageResolutionsIterable.this.client.listPageResolutions((ListPageResolutionsRequest)((Object)ListPageResolutionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

