/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmcontacts.model.RecurrenceSettings;
import software.amazon.awssdk.services.ssmcontacts.model.RotationContactsArnListCopier;
import software.amazon.awssdk.services.ssmcontacts.model.SsmContactsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRotationRequest
extends SsmContactsRequest
implements ToCopyableBuilder<Builder, UpdateRotationRequest> {
    private static final SdkField<String> ROTATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RotationId").getter(UpdateRotationRequest.getter(UpdateRotationRequest::rotationId)).setter(UpdateRotationRequest.setter(Builder::rotationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationId").build()}).build();
    private static final SdkField<List<String>> CONTACT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContactIds").getter(UpdateRotationRequest.getter(UpdateRotationRequest::contactIds)).setter(UpdateRotationRequest.setter(Builder::contactIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(UpdateRotationRequest.getter(UpdateRotationRequest::startTime)).setter(UpdateRotationRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeZoneId").getter(UpdateRotationRequest.getter(UpdateRotationRequest::timeZoneId)).setter(UpdateRotationRequest.setter(Builder::timeZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()}).build();
    private static final SdkField<RecurrenceSettings> RECURRENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Recurrence").getter(UpdateRotationRequest.getter(UpdateRotationRequest::recurrence)).setter(UpdateRotationRequest.setter(Builder::recurrence)).constructor(RecurrenceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_ID_FIELD, CONTACT_IDS_FIELD, START_TIME_FIELD, TIME_ZONE_ID_FIELD, RECURRENCE_FIELD));
    private final String rotationId;
    private final List<String> contactIds;
    private final Instant startTime;
    private final String timeZoneId;
    private final RecurrenceSettings recurrence;

    private UpdateRotationRequest(BuilderImpl builder) {
        super(builder);
        this.rotationId = builder.rotationId;
        this.contactIds = builder.contactIds;
        this.startTime = builder.startTime;
        this.timeZoneId = builder.timeZoneId;
        this.recurrence = builder.recurrence;
    }

    public final String rotationId() {
        return this.rotationId;
    }

    public final boolean hasContactIds() {
        return this.contactIds != null && !(this.contactIds instanceof SdkAutoConstructList);
    }

    public final List<String> contactIds() {
        return this.contactIds;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final String timeZoneId() {
        return this.timeZoneId;
    }

    public final RecurrenceSettings recurrence() {
        return this.recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.rotationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContactIds() ? this.contactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRotationRequest)) {
            return false;
        }
        UpdateRotationRequest other = (UpdateRotationRequest)((Object)obj);
        return Objects.equals(this.rotationId(), other.rotationId()) && this.hasContactIds() == other.hasContactIds() && Objects.equals(this.contactIds(), other.contactIds()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.timeZoneId(), other.timeZoneId()) && Objects.equals(this.recurrence(), other.recurrence());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRotationRequest").add("RotationId", (Object)this.rotationId()).add("ContactIds", this.hasContactIds() ? this.contactIds() : null).add("StartTime", (Object)this.startTime()).add("TimeZoneId", (Object)this.timeZoneId()).add("Recurrence", (Object)this.recurrence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RotationId": {
                return Optional.ofNullable(clazz.cast(this.rotationId()));
            }
            case "ContactIds": {
                return Optional.ofNullable(clazz.cast(this.contactIds()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "TimeZoneId": {
                return Optional.ofNullable(clazz.cast(this.timeZoneId()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRotationRequest, T> g) {
        return obj -> g.apply((UpdateRotationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmContactsRequest.BuilderImpl
    implements Builder {
        private String rotationId;
        private List<String> contactIds = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private String timeZoneId;
        private RecurrenceSettings recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRotationRequest model) {
            super(model);
            this.rotationId(model.rotationId);
            this.contactIds(model.contactIds);
            this.startTime(model.startTime);
            this.timeZoneId(model.timeZoneId);
            this.recurrence(model.recurrence);
        }

        public final String getRotationId() {
            return this.rotationId;
        }

        public final void setRotationId(String rotationId) {
            this.rotationId = rotationId;
        }

        @Override
        public final Builder rotationId(String rotationId) {
            this.rotationId = rotationId;
            return this;
        }

        public final Collection<String> getContactIds() {
            if (this.contactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contactIds;
        }

        public final void setContactIds(Collection<String> contactIds) {
            this.contactIds = RotationContactsArnListCopier.copy(contactIds);
        }

        @Override
        public final Builder contactIds(Collection<String> contactIds) {
            this.contactIds = RotationContactsArnListCopier.copy(contactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactIds(String ... contactIds) {
            this.contactIds(Arrays.asList(contactIds));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTimeZoneId() {
            return this.timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final RecurrenceSettings.Builder getRecurrence() {
            return this.recurrence != null ? this.recurrence.toBuilder() : null;
        }

        public final void setRecurrence(RecurrenceSettings.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(RecurrenceSettings recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRotationRequest build() {
            return new UpdateRotationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmContactsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRotationRequest> {
        public Builder rotationId(String var1);

        public Builder contactIds(Collection<String> var1);

        public Builder contactIds(String ... var1);

        public Builder startTime(Instant var1);

        public Builder timeZoneId(String var1);

        public Builder recurrence(RecurrenceSettings var1);

        default public Builder recurrence(Consumer<RecurrenceSettings.Builder> recurrence) {
            return this.recurrence((RecurrenceSettings)((RecurrenceSettings.Builder)RecurrenceSettings.builder().applyMutation(recurrence)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

