/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationOverridesRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationOverridesResponse;
import software.amazon.awssdk.services.ssmcontacts.model.RotationOverride;

public class ListRotationOverridesIterable
implements SdkIterable<ListRotationOverridesResponse> {
    private final SsmContactsClient client;
    private final ListRotationOverridesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRotationOverridesIterable(SsmContactsClient client, ListRotationOverridesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRotationOverridesResponseFetcher();
    }

    public Iterator<ListRotationOverridesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RotationOverride> rotationOverrides() {
        Function<ListRotationOverridesResponse, Iterator> getIterator = response -> {
            if (response != null && response.rotationOverrides() != null) {
                return response.rotationOverrides().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRotationOverridesResponseFetcher
    implements SyncPageFetcher<ListRotationOverridesResponse> {
        private ListRotationOverridesResponseFetcher() {
        }

        public boolean hasNextPage(ListRotationOverridesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRotationOverridesResponse nextPage(ListRotationOverridesResponse previousPage) {
            if (previousPage == null) {
                return ListRotationOverridesIterable.this.client.listRotationOverrides(ListRotationOverridesIterable.this.firstRequest);
            }
            return ListRotationOverridesIterable.this.client.listRotationOverrides((ListRotationOverridesRequest)((Object)ListRotationOverridesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

