/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ContactChannel;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse;

public class ListContactChannelsPublisher
implements SdkPublisher<ListContactChannelsResponse> {
    private final SsmContactsAsyncClient client;
    private final ListContactChannelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListContactChannelsPublisher(SsmContactsAsyncClient client, ListContactChannelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListContactChannelsPublisher(SsmContactsAsyncClient client, ListContactChannelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListContactChannelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListContactChannelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ContactChannel> contactChannels() {
        Function<ListContactChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.contactChannels() != null) {
                return response.contactChannels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListContactChannelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListContactChannelsResponseFetcher
    implements AsyncPageFetcher<ListContactChannelsResponse> {
        private ListContactChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListContactChannelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListContactChannelsResponse> nextPage(ListContactChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListContactChannelsPublisher.this.client.listContactChannels(ListContactChannelsPublisher.this.firstRequest);
            }
            return ListContactChannelsPublisher.this.client.listContactChannels((ListContactChannelsRequest)((Object)ListContactChannelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

